export const decisionCompletion = `specVersion: alpha
kind: YaRD
name: 'Traffic Violation'
expressionLang: alpha
inputs:
 - name: 'Driver'
   type: 'http://myapi.org/jsonSchema.json#Driver'
 - name: 'Violation'
   type: 'http://myapi.org/jsonSchema.json#Violation'
elements:
 - name: 'Fine'
   type: Decision
   requirements: ['Violation']
   logic:
     type: DecisionTable
     inputs: ['Violation.type', 'Violation.Speed - Violation.SpeedLimit']
     outputComponents: ['Amount', 'Points']
     rules:
      - ['="speed"', '[10..30)', 500, 3]
      - ['="speed"', '>= 30', 1000, 7]
      - ['="parking"', '-', 100, 1]
      - ['="driving under the influence"', '-', 1000, 5]
 - name: 'Should the driver be suspended?'
   type: Decision
   requirements: ['Driver', 'Fine']
   logic:
     type: LiteralExpression
     expression: 'if Driver.Points + Fine.Points >= 20 then "Yes" else "No"'`;
//# sourceMappingURL=decision-completion.js.map