import { CompletionItemKind, InsertTextFormat, Range } from "vscode-languageserver-types";
import { decisionCompletion, emptyDecisionCompletion } from "../assets/code-completions/";
export const YardLanguageServiceCodeCompletion = {
    getEmptyFileCodeCompletions(args) {
        const kind = CompletionItemKind.Text;
        const emptyDecisionLabel = "Empty Serverless Decision";
        const exampleDecisionLabel = "Serverless Decision Example";
        return Promise.resolve([
            {
                kind,
                label: exampleDecisionLabel,
                detail: "Start with a simple Serverless Decision",
                sortText: `100_${exampleDecisionLabel}`,
                textEdit: {
                    newText: args.codeCompletionStrategy.translate({
                        ...args,
                        completion: decisionCompletion,
                        completionItemKind: kind,
                    }),
                    range: Range.create(args.cursorPosition, args.cursorPosition),
                },
                insertTextFormat: InsertTextFormat.Snippet,
            },
            {
                kind,
                label: emptyDecisionLabel,
                detail: "Start with an empty Serverless Decision",
                sortText: `100_${emptyDecisionLabel}`,
                textEdit: {
                    newText: args.codeCompletionStrategy.translate({
                        ...args,
                        completion: emptyDecisionCompletion,
                        completionItemKind: kind,
                    }),
                    range: Range.create(args.cursorPosition, args.cursorPosition),
                },
                insertTextFormat: InsertTextFormat.Snippet,
            },
        ]);
    },
};
//# sourceMappingURL=YardLanguageServiceCodeCompletion.js.map