import * as React from "react";
import { BeeGwtService, BoxedExpression, DmnDataType, ExpressionChangedArgs, Normalized, PmmlDocument } from "./api";
import { BoxedExpressionEditorProps, OnRequestFeelIdentifiers } from "./BoxedExpressionEditor";
import "./BoxedExpressionEditorContext.css";
export interface BoxedExpressionEditorContextType {
    beeGwtService?: BeeGwtService;
    editorRef: React.RefObject<HTMLDivElement>;
    scrollableParentRef: React.RefObject<HTMLElement>;
    expressionHolderId: string;
    pmmlDocuments?: PmmlDocument[];
    dataTypes: DmnDataType[];
    isReadOnly?: boolean;
    evaluationHitsCountById?: Map<string, number>;
    currentlyOpenContextMenu: string | undefined;
    setCurrentlyOpenContextMenu: React.Dispatch<React.SetStateAction<string | undefined>>;
    onRequestFeelIdentifiers?: OnRequestFeelIdentifiers;
    widthsById: Map<string, number[]>;
    hideDmn14BoxedExpressions?: boolean;
}
export interface BoxedExpressionEditorDispatchContextType {
    setExpression: OnExpressionChange;
    setWidthsById: (mutation: ({ newMap }: {
        newMap: Map<string, number[]>;
    }) => void) => void;
}
export declare const BoxedExpressionEditorContext: React.Context<BoxedExpressionEditorContextType>;
export declare const BoxedExpressionEditorDispatchContext: React.Context<BoxedExpressionEditorDispatchContextType>;
export declare function useBoxedExpressionEditor(): BoxedExpressionEditorContextType;
export declare function useBoxedExpressionEditorDispatch(): BoxedExpressionEditorDispatchContextType;
export declare function BoxedExpressionEditorContextProvider({ onExpressionChange, onWidthsChange, dataTypes, isReadOnly, expressionHolderId, beeGwtService, children, pmmlDocuments, evaluationHitsCountById, scrollableParentRef, onRequestFeelIdentifiers, widthsById, hideDmn14BoxedExpressions, }: React.PropsWithChildren<BoxedExpressionEditorProps>): JSX.Element;
export type OnSetExpression = (args: {
    getNewExpression: (prev: Normalized<BoxedExpression> | undefined) => Normalized<BoxedExpression> | undefined;
    expressionChangedArgs: ExpressionChangedArgs;
}) => void;
export type OnExpressionChange = (args: {
    setExpressionAction: React.SetStateAction<Normalized<BoxedExpression> | undefined>;
    expressionChangedArgs: ExpressionChangedArgs;
}) => void;
export declare function NestedExpressionDispatchContextProvider({ onSetExpression, children, }: React.PropsWithChildren<{
    onSetExpression: OnSetExpression;
}>): JSX.Element;
//# sourceMappingURL=BoxedExpressionEditorContext.d.ts.map