import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useEffect, useImperativeHandle, useMemo, useState } from "react";
import { Popover, PopoverPosition } from "@patternfly/react-core/dist/js/components/Popover";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
import { NavigationKeysUtils } from "../../keysUtils/keyUtils";
import { generateUuid } from "../../api";
import "./PopoverMenu.css";
const POPUP_DROP_DOWN_RESERVED_HEIGHT = 200;
const POPUP_DEFAULT_HEIGHT = 200;
export const PopoverMenu = React.forwardRef(({ children, arrowPlacement, body, position, distance, appendTo, className, hasAutoWidth, minWidth, onHide = () => { }, onCancel = () => { }, onShown = () => { }, }, ref) => {
    var _a;
    const { currentlyOpenContextMenu, setCurrentlyOpenContextMenu } = useBoxedExpressionEditor();
    const [isPopoverVisible, setIsPopoverVisible] = useState(false);
    const id = useMemo(() => generateUuid(), []);
    useEffect(() => {
        setIsPopoverVisible(currentlyOpenContextMenu == id);
    }, [id, currentlyOpenContextMenu]);
    const onPopoverShown = useCallback(() => {
        setCurrentlyOpenContextMenu(id);
        onShown();
    }, [setCurrentlyOpenContextMenu, id, onShown]);
    const shouldOpen = useCallback((showFunction) => {
        showFunction === null || showFunction === void 0 ? void 0 : showFunction();
    }, []);
    const shouldClose = useCallback((tip, hideFunction, event) => {
        if (event instanceof KeyboardEvent && NavigationKeysUtils.isEsc(event.key)) {
            onCancel(event);
        }
        else {
            hideFunction === null || hideFunction === void 0 ? void 0 : hideFunction();
        }
    }, [onCancel]);
    const onHideCallback = useCallback((tip) => {
        if (currentlyOpenContextMenu) {
            onHide();
            setCurrentlyOpenContextMenu(undefined);
        }
    }, [currentlyOpenContextMenu, onHide, setCurrentlyOpenContextMenu]);
    useImperativeHandle(ref, () => ({
        setIsVisible: (isVisible) => {
            setCurrentlyOpenContextMenu(isVisible ? id : undefined);
        },
    }));
    const appendElement = useMemo(() => {
        if (appendTo instanceof HTMLElement) {
            return appendTo;
        }
        else if (appendTo) {
            return appendTo();
        }
    }, [appendTo]);
    const yPos = (_a = appendElement === null || appendElement === void 0 ? void 0 : appendElement.getBoundingClientRect().top) !== null && _a !== void 0 ? _a : 0;
    const popupPosition = useMemo(() => {
        if (appendElement) {
            const availableHeight = document.documentElement.clientHeight;
            if (POPUP_DEFAULT_HEIGHT + yPos + POPUP_DROP_DOWN_RESERVED_HEIGHT > availableHeight) {
                return PopoverPosition.right;
            }
        }
        return PopoverPosition.bottom;
    }, [appendElement, yPos]);
    return (_jsx(Popover, { id: "menu-selector", "data-ouia-component-id": "expression-popover-menu", "data-testid": "kie-tools--bee--expression-popover-menu", className: `popover-menu-selector ${className !== null && className !== void 0 ? className : ""}`, hasAutoWidth: hasAutoWidth, minWidth: minWidth, position: popupPosition, distance: distance !== null && distance !== void 0 ? distance : 0, reference: arrowPlacement, appendTo: appendTo, headerContent: _jsx("div", { style: { height: "1px" } }), bodyContent: body, isVisible: isPopoverVisible, onShown: onPopoverShown, onHide: onHideCallback, shouldClose: shouldClose, shouldOpen: shouldOpen, flipBehavior: ["bottom-start", "bottom", "bottom-end", "right-start", "left-start", "right-end", "left-end"], children: children }));
});
//# sourceMappingURL=PopoverMenu.js.map