import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback } from "react";
import { useBoxedExpressionEditorDispatch, NestedExpressionDispatchContextProvider, } from "../../BoxedExpressionEditorContext";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
export function ListItemCell({ rowIndex, data: items, columnIndex, parentElementId, listExpression, }) {
    var _a;
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onSetExpression = useCallback(({ getNewExpression, expressionChangedArgs }) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const newItems = [...((_a = prev.expression) !== null && _a !== void 0 ? _a : [])];
                newItems[rowIndex] = getNewExpression(newItems[rowIndex]);
                const ret = {
                    ...prev,
                    expression: newItems,
                };
                return ret;
            },
            expressionChangedArgs,
        });
    }, [rowIndex, setExpression]);
    return (_jsx(NestedExpressionDispatchContextProvider, { onSetExpression: onSetExpression, children: _jsx(ExpressionContainer, { expression: (_a = items[rowIndex]) === null || _a === void 0 ? void 0 : _a.expression, isResetSupported: true, isNested: true, rowIndex: rowIndex, columnIndex: columnIndex, parentElementId: parentElementId, parentElementTypeRef: listExpression["@_typeRef"] }) }));
}
//# sourceMappingURL=ListItemCell.js.map