import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import PlusIcon from "@patternfly/react-icons/dist/js/icons/plus-icon";
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { useCellWidthToFitData } from "../../resizing/BeeTableCellWidthToFitDataContext";
import { useBeeTableResizableCell } from "../../resizing/BeeTableResizableColumnsContext";
import { Resizer } from "../../resizing/Resizer";
import { BeeTableCoordinatesContextProvider, useBeeTableSelectableCell, useBeeTableSelectableCellRef, } from "../../selection/BeeTableSelectionContext";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
import { InsertRowColumnsDirection } from "../../api";
export function BeeTableTd({ columnIndex, row, column, rowIndex, shouldRenderInlineButtons, shouldShowRowsInlineControls, resizerStopBehavior, onRowAdded, lastColumnMinWidth, onDataCellClick, onDataCellKeyUp, isReadOnly, canDisplayEvaluationHitsCountBadge, evaluationHitsCount, }) {
    var _a, _b;
    const [isResizing, setResizing] = useState(false);
    const [hoverInfo, setHoverInfo] = useState({ isHovered: false });
    const tdRef = useRef(null);
    const cssClass = column.isRowIndexColumn ? "row-index-column-cell" : "data-cell";
    const cell = useMemo(() => {
        return row.cells[columnIndex];
    }, [columnIndex, row]);
    const cellWidthToFitDataRef = useCellWidthToFitData(rowIndex, columnIndex);
    const { resizingWidth, setResizingWidth } = useBeeTableResizableCell(columnIndex, resizerStopBehavior, column.width, column.setWidth, column.width ? Math.max((_a = lastColumnMinWidth !== null && lastColumnMinWidth !== void 0 ? lastColumnMinWidth : column.minWidth) !== null && _a !== void 0 ? _a : 0, (_b = column.width) !== null && _b !== void 0 ? _b : 0) : undefined);
    const rowIndexLabel = useMemo(() => {
        return `${rowIndex + 1}`;
    }, [rowIndex]);
    const getValue = useMemo(() => {
        if (column.isRowIndexColumn) {
            return () => rowIndexLabel;
        }
        return undefined;
    }, [column.isRowIndexColumn, rowIndexLabel]);
    const { isActive } = useBeeTableSelectableCellRef(rowIndex, columnIndex, undefined);
    const { beeGwtService, editorRef } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            if (column.isRowIndexColumn) {
                beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject("");
            }
        }
    }, [beeGwtService, isActive, column.isRowIndexColumn, cell.value]);
    useEffect(() => {
        const td = tdRef.current;
        function hasTextSelectedInBoxedExpressionEditor() {
            var _a;
            const selection = window.getSelection();
            if (selection) {
                return (selection === null || selection === void 0 ? void 0 : selection.toString()) && ((_a = editorRef.current) === null || _a === void 0 ? void 0 : _a.contains(selection.focusNode));
            }
            return false;
        }
        function onEnter(e) {
            e.stopPropagation();
            if (hasTextSelectedInBoxedExpressionEditor()) {
                return;
            }
            setHoverInfo((prev) => getHoverInfo(e, td));
        }
        function onMove(e) {
            if (hasTextSelectedInBoxedExpressionEditor()) {
                return;
            }
            setHoverInfo((prev) => getHoverInfo(e, td));
        }
        function onLeave() {
            setHoverInfo((prev) => ({ isHovered: false }));
        }
        td === null || td === void 0 ? void 0 : td.addEventListener("mouseenter", onEnter);
        td === null || td === void 0 ? void 0 : td.addEventListener("mousemove", onMove);
        td === null || td === void 0 ? void 0 : td.addEventListener("mouseleave", onLeave);
        return () => {
            td === null || td === void 0 ? void 0 : td.removeEventListener("mouseleave", onLeave);
            td === null || td === void 0 ? void 0 : td.removeEventListener("mousemove", onMove);
            td === null || td === void 0 ? void 0 : td.removeEventListener("mouseenter", onEnter);
        };
    }, [editorRef]);
    const onAddRowButtonClick = useCallback((e) => {
        e.stopPropagation();
        if (!hoverInfo.isHovered) {
            return;
        }
        onRowAdded === null || onRowAdded === void 0 ? void 0 : onRowAdded({
            beforeIndex: hoverInfo.part === "upper" ? rowIndex : rowIndex + 1,
            rowsCount: 1,
            insertDirection: InsertRowColumnsDirection.BelowOrLeft,
        });
        if (hoverInfo.part === "upper") {
            setHoverInfo({ isHovered: false });
        }
    }, [hoverInfo, onRowAdded, rowIndex]);
    const addRowButtonStyle = useMemo(() => hoverInfo.isHovered && hoverInfo.part === "lower"
        ? {
            bottom: "-9px",
        }
        : {
            top: "-10px",
        }, [hoverInfo]);
    const coordinates = useMemo(() => ({
        rowIndex,
        columnIndex,
    }), [columnIndex, rowIndex]);
    const { cssClasses, onMouseDown, onDoubleClick } = useBeeTableSelectableCell(tdRef, rowIndex, columnIndex, undefined, getValue);
    const tdContent = useMemo(() => {
        return cell.render("Cell");
    }, [cell]);
    const shouldRenderResizer = useMemo(() => !column.isWidthConstant && (hoverInfo.isHovered || isActive || ((resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.isPivoting) && isResizing)), [column.isWidthConstant, hoverInfo.isHovered, isActive, isResizing, resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.isPivoting]);
    const onClick = useCallback(() => {
        return onDataCellClick === null || onDataCellClick === void 0 ? void 0 : onDataCellClick(column.id);
    }, [column.id, onDataCellClick]);
    const onKeyUp = useCallback(() => {
        return onDataCellKeyUp === null || onDataCellKeyUp === void 0 ? void 0 : onDataCellKeyUp(column.id);
    }, [column.id, onDataCellKeyUp]);
    const evaluationHitsCountBadgeClassName = useMemo(() => {
        return canDisplayEvaluationHitsCountBadge
            ? (evaluationHitsCount !== null && evaluationHitsCount !== void 0 ? evaluationHitsCount : 0) > 0
                ? "evaluation-hits-count-badge-colored"
                : "evaluation-hits-count-badge-non-colored"
            : "";
    }, [canDisplayEvaluationHitsCountBadge, evaluationHitsCount]);
    return (_jsx(BeeTableCoordinatesContextProvider, { coordinates: coordinates, children: _jsxs("td", { onMouseDown: onMouseDown, onDoubleClick: isReadOnly ? undefined : onDoubleClick, onClick: onClick, onKeyUp: isReadOnly ? undefined : onKeyUp, ref: tdRef, tabIndex: -1, className: `${cssClass} ${cssClasses} ${column.cssClasses}`, "data-testid": `kie-tools--bee--expression-column-${columnIndex}`, "data-ouia-component-id": `expression-column-${columnIndex}`, style: {
                outline: "none",
                minHeight: `60px`,
                width: column.width ? resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.value : "100%",
                minWidth: column.width ? resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.value : "100%",
                maxWidth: column.width ? resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.value : "100%",
            }, children: [column.isRowIndexColumn ? (_jsx("div", { className: evaluationHitsCountBadgeClassName, "data-evaluation-hits-count": evaluationHitsCount, children: rowIndexLabel })) : (_jsxs("div", { className: evaluationHitsCountBadgeClassName, "data-evaluation-hits-count": evaluationHitsCount, children: [tdContent, !isReadOnly && shouldRenderResizer && (_jsx(Resizer, { getWidthToFitData: cellWidthToFitDataRef === null || cellWidthToFitDataRef === void 0 ? void 0 : cellWidthToFitDataRef.getWidthToFitData, minWidth: lastColumnMinWidth !== null && lastColumnMinWidth !== void 0 ? lastColumnMinWidth : cell.column.minWidth, width: cell.column.width, setWidth: cell.column.setWidth, resizingWidth: resizingWidth, setResizingWidth: setResizingWidth, setResizing: setResizing }))] })), !isReadOnly &&
                    hoverInfo.isHovered &&
                    shouldRenderInlineButtons &&
                    onRowAdded &&
                    shouldShowRowsInlineControls && (_jsx("div", { style: {
                        display: "flex",
                        justifyContent: "center",
                    }, children: _jsx("div", { onMouseDown: (e) => e.stopPropagation(), onDoubleClick: (e) => e.stopPropagation(), onClick: onAddRowButtonClick, className: "add-row-button", style: addRowButtonStyle, children: _jsx(PlusIcon, { size: "sm" }) }) }))] }) }));
}
function getHoverInfo(e, elem) {
    const rect = elem.getBoundingClientRect();
    const localY = e.clientY - rect.top;
    const part = localY < rect.height / 3 ? "upper" : "lower";
    return { isHovered: true, part };
}
//# sourceMappingURL=BeeTableTd.js.map