import { CharStream, CommonTokenStream } from "antlr4";
import FEEL_1_1Parser from "./grammar/generated-parser/FEEL_1_1Parser";
import FEEL_1_1Lexer from "./grammar/generated-parser/FEEL_1_1Lexer";
import { MapBackedType } from "./grammar/MapBackedType";
import { FeelSyntacticSymbolNature } from "./FeelSyntacticSymbolNature";
export class FeelIdentifiersParser {
    constructor(identifiersRepository) {
        this.repository = identifiersRepository;
    }
    parse(variableContextUuid, expression) {
        const variables = new Array();
        const chars = new CharStream(expression);
        const lexer = new FEEL_1_1Lexer(chars);
        const feelTokens = new CommonTokenStream(lexer);
        const parser = new FEEL_1_1Parser(feelTokens);
        const variableContext = this.repository.identifiers.get(variableContextUuid);
        if (variableContext) {
            this.defineVariables(variableContext, parser);
        }
        parser.removeErrorListeners();
        parser.expression();
        variables.push(...parser.helper.variables);
        return {
            availableSymbols: parser.helper.availableSymbols,
            feelIdentifiedSymbols: variables,
        };
    }
    defineVariables(variableContext, parser) {
        this.defineInputVariables(variableContext.inputIdentifiers, parser);
        this.addToParser(parser, variableContext);
        if (variableContext.parent) {
            this.defineParentVariable(variableContext.parent, parser);
        }
        for (const inputVariableContext of variableContext.inputIdentifiers) {
            const localVariable = this.repository.identifiers.get(inputVariableContext);
            if (localVariable) {
                this.addToParser(parser, localVariable);
            }
        }
    }
    defineParentVariable(variableNode, parser) {
        this.defineInputVariables(variableNode.inputIdentifiers, parser);
        this.addToParser(parser, variableNode);
        if (variableNode.parent) {
            this.defineParentVariable(variableNode.parent, parser);
        }
    }
    createType(dataType) {
        var _a;
        if (typeof dataType !== "string") {
            const type = new MapBackedType(dataType.name, (_a = dataType.typeRef) !== null && _a !== void 0 ? _a : dataType.name, dataType.source);
            for (const property of dataType.properties) {
                const innerType = this.createType(property[1]);
                type.properties.set(property[0], innerType);
            }
            return type;
        }
        else {
            return {
                name: dataType,
                typeRef: dataType,
                source: {
                    value: dataType,
                    feelSyntacticSymbolNature: FeelSyntacticSymbolNature.GlobalVariable,
                    expressionsThatUseTheIdentifier: new Map(),
                },
            };
        }
    }
    defineInputVariables(inputVariables, parser) {
        for (const inputVariableId of inputVariables) {
            const inputVariable = this.repository.identifiers.get(inputVariableId);
            if (inputVariable) {
                this.addToParser(parser, inputVariable, true);
            }
        }
    }
    addToParser(parser, context, addInvisibleVariables) {
        if (context.identifier.value !== "" &&
            ((!addInvisibleVariables &&
                context.identifier.feelSyntacticSymbolNature != FeelSyntacticSymbolNature.InvisibleVariables) ||
                addInvisibleVariables)) {
            parser.helper.defineVariable(context.identifier.value, context.identifier.typeRef ? this.createType(context.identifier.typeRef) : undefined, context.identifier.feelSyntacticSymbolNature, context.identifier, context.allowDynamicVariables);
        }
    }
}
//# sourceMappingURL=FeelIdentifiersParser.js.map