import { DataType } from "./DataType";
import { IdentifierContext } from "./IdentifierContext";
import { DMN15__tConditional, DMN15__tContext, DMN15__tContextEntry, DMN15__tDecision, DMN15__tDecisionTable, DMN15__tDefinitions, DMN15__tFilter, DMN15__tFor, DMN15__tFunctionDefinition, DMN15__tInvocation, DMN15__tKnowledgeRequirement, DMN15__tList, DMN15__tLiteralExpression, DMN15__tQuantified, DMN15__tRelation } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import { Expression } from "./Expression";
import { DmnLatestModel } from "@kie-tools/dmn-marshaller";
export type ExpressionSource = {
    text?: {
        __$$text: string;
    };
    "@_id"?: string;
};
export type DmnLiteralExpression = {
    __$$element: "literalExpression";
} & DMN15__tLiteralExpression;
export type DmnInvocation = {
    __$$element: "invocation";
} & DMN15__tInvocation;
export type DmnDecisionTable = {
    __$$element: "decisionTable";
} & DMN15__tDecisionTable;
export type DmnContext = {
    __$$element: "context";
} & DMN15__tContext;
export type DmnFunctionDefinition = {
    __$$element: "functionDefinition";
} & DMN15__tFunctionDefinition;
export type DmnRelation = {
    __$$element: "relation";
} & DMN15__tRelation;
export type DmnList = {
    __$$element: "list";
} & DMN15__tList;
export type DmnConditional = {
    __$$element: "conditional";
} & DMN15__tConditional;
export type DmnFilter = {
    __$$element: "filter";
} & DMN15__tFilter;
export type DmnFor = {
    __$$element: "for";
} & DMN15__tFor;
export type DmnEvery = {
    __$$element: "every";
} & DMN15__tQuantified;
export type DmnSome = {
    __$$element: "some";
} & DMN15__tQuantified;
export type DmnDecisionNode = {
    __$$element: "decision";
} & DMN15__tDecision;
export type DmnDefinitions = DMN15__tDefinitions;
export type DmnKnowledgeRequirement = DMN15__tKnowledgeRequirement;
export type DmnContextEntry = DMN15__tContextEntry;
export declare class IdentifiersRepository {
    private dmnDefinitions;
    private externalDefinitions?;
    private readonly _identifiersContextIndexedByUuid;
    private readonly _expressionsIndexedByUuid;
    private readonly _dataTypes;
    private readonly _dataTypeIndexedByUuid;
    private readonly _importedIdentifiers;
    private readonly _importedDataTypes;
    private currentIdentifierNamePrefix;
    private currentUuidPrefix;
    constructor(dmnDefinitions: DmnDefinitions, externalDefinitions?: Map<string, DmnLatestModel> | undefined);
    get identifiersContextIndexedByUuid(): Map<string, IdentifierContext>;
    get expressionsIndexedByUuid(): Map<string, Expression>;
    get dataTypeIndexedByUuid(): Map<string, DataType>;
    get importedDataTypes(): Map<string, Array<DataType>>;
    get importedIdentifiers(): Map<string, Array<IdentifierContext>>;
    get identifiers(): Map<string, IdentifierContext>;
    get dataTypes(): Map<string, DataType>;
    get expressions(): Map<string, Expression>;
    reload(): void;
    private createDataTypes;
    private addImportedDataType;
    private loadIdentifiersFromDefinitions;
    private loadIdentifiersFromInputData;
    private loadIdentifiersFromDecisionService;
    private loadIdentifiersFromBkm;
    private loadIdentifiersFromDecision;
    private addIdentifierContext;
    private createIdentifierContext;
    getTypeRef(typeRef: string | undefined): string | DataType | undefined;
    private createDataType;
    private createInnerType;
    private buildProperties;
    private addExpression;
    private addInvocation;
    private addContext;
    private addContextEntry;
    private addFunctionDefinition;
    private addRelation;
    private addList;
    private addConditional;
    private addIterable;
    private addFor;
    private addFilterVariable;
    private addIteratorVariable;
    private addFilter;
    private addInnerExpression;
    private addDecisionTableEntryNode;
    private addDecisionTableInputEntryNode;
    private addDecisionTable;
    private addInputVariable;
    private addInputVariableFromKnowledge;
    private buildIdentifierUuid;
    private buildName;
    private loadIdentifiers;
    private loadImportedIdentifiers;
}
//# sourceMappingURL=IdentifiersRepository.d.ts.map