import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { EmbeddedWorkflowList } from "@kie-tools/runtime-tools-swf-enveloped-components/dist/workflowList/embedded";
import { useWorkflowListGatewayApi } from "../WorkflowList/WorkflowListContext";
export const WorkflowListContainer = ({ initialState, onOpenWorkflowDetails, onOpenTriggerCloudEventForWorkflow, ouiaId, ouiaSafe, targetOrigin, }) => {
    const gatewayApi = useWorkflowListGatewayApi();
    useEffect(() => {
        const onOpenInstanceUnsubscriber = gatewayApi.onOpenWorkflowListen({
            onOpen(workflow) {
                onOpenWorkflowDetails({ workflowId: workflow.id, state: gatewayApi.workflowListState });
            },
        });
        const onTriggerCloudEventUnsubscriber = gatewayApi.onOpenTriggerCloudEventListen({
            onOpen(workflowInstance) {
                if (workflowInstance) {
                    onOpenTriggerCloudEventForWorkflow === null || onOpenTriggerCloudEventForWorkflow === void 0 ? void 0 : onOpenTriggerCloudEventForWorkflow(workflowInstance.id);
                }
            },
        });
        return () => {
            onOpenInstanceUnsubscriber.unSubscribe();
            onTriggerCloudEventUnsubscriber === null || onTriggerCloudEventUnsubscriber === void 0 ? void 0 : onTriggerCloudEventUnsubscriber.unSubscribe();
        };
    }, [gatewayApi, onOpenTriggerCloudEventForWorkflow, onOpenWorkflowDetails]);
    return (_jsx(EmbeddedWorkflowList, { ...componentOuiaProps(ouiaId, "workflow-list-container", ouiaSafe), driver: gatewayApi, targetOrigin: targetOrigin || window.location.origin, initialState: initialState }));
};
//# sourceMappingURL=WorkflowListContainer.js.map