export var OperatingSystem;
(function (OperatingSystem) {
    OperatingSystem["MACOS"] = "MACOS";
    OperatingSystem["WINDOWS"] = "WINDOWS";
    OperatingSystem["LINUX"] = "LINUX";
})(OperatingSystem || (OperatingSystem = {}));
export function getOperatingSystem() {
    if (navigator.appVersion.indexOf("Win") !== -1) {
        return OperatingSystem.WINDOWS;
    }
    if (navigator.appVersion.indexOf("Mac") !== -1) {
        return OperatingSystem.MACOS;
    }
    if (navigator.appVersion.indexOf("X11") !== -1) {
        return OperatingSystem.LINUX;
    }
    if (navigator.appVersion.indexOf("Linux") !== -1) {
        return OperatingSystem.LINUX;
    }
    return undefined;
}
//# sourceMappingURL=OperatingSystem.js.map