import { jsx as _jsx } from "react/jsx-runtime";
import React, { useEffect, useImperativeHandle, useMemo, useState } from "react";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import CloudEventForm from "./components/CloudEventForm/CloudEventForm";
import { CloudEventFormEnvelopeViewDriver } from "./CloudEventFormEnvelopeViewDriver";
import { Card, CardBody } from "@patternfly/react-core/dist/js/components/Card";
export const CloudEventFormEnvelopeView = React.forwardRef(({ channelApi, ouiaId }, forwardedRef) => {
    const [isLoading, setIsLoading] = useState(true);
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [isNewInstanceEvent, setIsNewInstanceEvent] = useState(false);
    const [defaultValues, setDefaultValues] = useState();
    const [serviceUrl, setServiceUrl] = useState("");
    useImperativeHandle(forwardedRef, () => ({
        initialize: (args) => {
            setEnvelopeConnectedToChannel(true);
            setIsNewInstanceEvent(args.isNewInstanceEvent);
            setDefaultValues(args.defaultValues);
            setServiceUrl(args.serviceUrl);
        },
    }), []);
    useEffect(() => {
        setIsLoading(false);
    }, [isEnvelopeConnectedToChannel]);
    const driver = useMemo(() => new CloudEventFormEnvelopeViewDriver(channelApi), [channelApi]);
    if (isLoading) {
        return (_jsx(Bullseye, { ...componentOuiaProps((ouiaId ? ouiaId : "cloud-event-form-envelope-view") + "-loading-spinner", "cloud-event-form", true), children: _jsx(KogitoSpinner, { spinnerText: `Loading cloud event form...` }) }));
    }
    return (_jsx(Card, { children: _jsx(CardBody, { children: _jsx(CloudEventForm, { driver: driver, serviceUrl: serviceUrl, isNewInstanceEvent: isNewInstanceEvent, defaultValues: defaultValues }) }) }));
});
export default CloudEventFormEnvelopeView;
//# sourceMappingURL=CloudEventFormEnvelopeView.js.map