import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useState, useEffect } from "react";
import { DropdownItem, Dropdown, KebabToggle } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { Toolbar, ToolbarContent, ToolbarFilter, ToolbarGroup, ToolbarItem, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { OverflowMenu, OverflowMenuContent, OverflowMenuItem, OverflowMenuControl, } from "@patternfly/react-core/dist/js/components/OverflowMenu";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const JobsManagementToolbar = ({ chips, driver, doQueryJobs, onResetToDefault, jobOperations, onRefresh, selectedStatus, selectedJobInstances, setChips, setDisplayTable, setIsLoading, setSelectedStatus, setSelectedJobInstances, ouiaId, ouiaSafe, }) => {
    const [isExpanded, setIsExpanded] = useState(false);
    const [chipRemoved, setChipRemoved] = useState(false);
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const statusMenuItems = [
        _jsx(SelectOption, { value: "CANCELED" }, "CANCELED"),
        _jsx(SelectOption, { value: "ERROR" }, "ERROR"),
        _jsx(SelectOption, { value: "EXECUTED" }, "EXECUTED"),
        _jsx(SelectOption, { value: "RETRY" }, "RETRY"),
        _jsx(SelectOption, { value: "SCHEDULED" }, "SCHEDULED"),
    ];
    const onStatusToggle = () => {
        setIsExpanded(!isExpanded);
    };
    const filterData = async () => {
        await driver.applyFilter(selectedStatus);
        doQueryJobs(0, 10);
        setChipRemoved(false);
    };
    const onApplyFilter = async () => {
        setChips(selectedStatus);
        setIsLoading(true);
        filterData();
    };
    const onDelete = (type, id) => {
        const chipsCopy = [...chips];
        const tempChips = chipsCopy.filter((item) => item !== id);
        setSelectedJobInstances([]);
        let selectedStatusCopy = [...selectedStatus];
        setChips(tempChips);
        selectedStatusCopy = selectedStatusCopy.filter((item) => item !== id);
        setSelectedStatus(selectedStatusCopy);
        if (tempChips.length > 0) {
            setIsLoading(true);
            setChipRemoved(true);
        }
        else {
            setDisplayTable(false);
        }
    };
    const onSelect = (event, selection) => {
        let selectionText = event.target.id;
        selectionText = selectionText.split("pf-random-id-")[1].split("-")[1];
        let selectedStatusCopy = [...selectedStatus];
        if (selectedStatus.includes(selectionText)) {
            selectedStatusCopy = selectedStatusCopy.filter((item) => item !== selectionText);
            setSelectedStatus(selectedStatusCopy);
        }
        else {
            selectedStatusCopy = [...selectedStatusCopy, selectionText];
            setSelectedStatus(selectedStatusCopy);
        }
    };
    const cancelJobsOptionSelect = () => {
        setIsKebabOpen(!isKebabOpen);
    };
    const cancelJobsKebabToggle = (isOpen) => {
        setIsKebabOpen(isOpen);
    };
    const dropdownItemsCancelJobsButtons = () => {
        return [
            _jsx(DropdownItem, { onClick: jobOperations[OperationType.CANCEL].functions.perform, isDisabled: selectedJobInstances.length === 0, children: "Cancel selected" }, "cancel"),
        ];
    };
    const cancelJobsOption = (_jsxs(OverflowMenu, { breakpoint: "xl", children: [_jsx(OverflowMenuContent, { children: _jsx(OverflowMenuItem, { children: _jsx(Button, { variant: "secondary", onClick: jobOperations[OperationType.CANCEL].functions.perform, isDisabled: selectedJobInstances.length === 0, children: "Cancel selected" }) }) }), _jsx(OverflowMenuControl, { children: _jsx(Dropdown, { onSelect: cancelJobsOptionSelect, toggle: _jsx(KebabToggle, { onToggle: cancelJobsKebabToggle }), isOpen: isKebabOpen, isPlain: true, dropdownItems: dropdownItemsCancelJobsButtons() }) })] }));
    useEffect(() => {
        if (chipRemoved) {
            filterData();
        }
    }, [chipRemoved]);
    return (_jsx(Toolbar, { id: "data-toolbar-with-chip-groups", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "md", clearAllFilters: () => {
            onResetToDefault();
        }, clearFiltersButtonText: "Reset to default", children: _jsxs(ToolbarContent, { children: [_jsx(ToolbarGroup, { variant: "filter-group", ...componentOuiaProps(ouiaId, "job-filters", ouiaSafe), children: _jsx(ToolbarFilter, { chips: chips, deleteChip: onDelete, categoryName: "Status", className: "kogito-jobs-management__state-dropdown-list", children: _jsx(Select, { variant: SelectVariant.checkbox, "aria-label": "Status", onToggle: onStatusToggle, onSelect: onSelect, selections: selectedStatus, isOpen: isExpanded, placeholderText: "Status", id: "status-select", children: statusMenuItems }) }) }), _jsx(ToolbarGroup, { ...componentOuiaProps(ouiaId, "job-filters/button", ouiaSafe), children: _jsx(ToolbarItem, { children: _jsx(Button, { variant: "primary", onClick: onApplyFilter, id: "apply-filter", isDisabled: !(selectedStatus.length > 0), children: "Apply Filter" }) }) }), _jsx(ToolbarGroup, { children: _jsx(ToolbarItem, { children: _jsx(Button, { variant: "plain", onClick: () => {
                                onRefresh();
                                setSelectedJobInstances([]);
                            }, id: "refresh-button", ouiaId: "refresh-button", "aria-label": "Refresh list", children: _jsx(SyncIcon, {}) }) }) }), _jsx(ToolbarItem, { variant: "separator" }), _jsx(ToolbarGroup, { className: "pf-u-ml-md", id: "jobs-management-buttons", children: cancelJobsOption })] }) }));
};
export default JobsManagementToolbar;
//# sourceMappingURL=JobsManagementToolbar.js.map