import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { UndoIcon } from "@patternfly/react-icons/dist/js/icons/undo-icon";
import { ClockIcon } from "@patternfly/react-icons/dist/js/icons/clock-icon";
import { ErrorCircleOIcon } from "@patternfly/react-icons/dist/js/icons/error-circle-o-icon";
import { BanIcon } from "@patternfly/react-icons/dist/js/icons/ban-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { JobStatus } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
export const JobsIconCreator = (state) => {
    switch (state) {
        case JobStatus.Error:
            return (_jsxs(_Fragment, { children: [_jsx(ErrorCircleOIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }), "Error"] }));
        case JobStatus.Canceled:
            return (_jsxs(_Fragment, { children: [_jsx(BanIcon, { className: "pf-u-mr-sm" }), "Canceled"] }));
        case JobStatus.Executed:
            return (_jsxs(_Fragment, { children: [_jsx(CheckCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--success-color--100)" }), "Executed"] }));
        case JobStatus.Retry:
            return (_jsxs(_Fragment, { children: [_jsx(UndoIcon, { className: "pf-u-mr-sm" }), "Retry"] }));
        case JobStatus.Scheduled:
            return (_jsxs(_Fragment, { children: [_jsx(ClockIcon, { className: "pf-u-mr-sm" }), "Scheduled"] }));
    }
};
//# sourceMappingURL=utils.js.map