import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import * as ReactDOM from "react-dom";
import { WorkflowDefinitionListEnvelopeView, } from "./WorkflowDefinitionListEnvelopeView";
import { WorkflowDefinitionListEnvelopeApiImpl } from "./WorkflowDefinitionListEnvelopeApiImpl";
import { Envelope } from "@kie-tools-core/envelope";
export function init(args) {
    const envelope = new Envelope(args.bus, args.config);
    const envelopeViewDelegate = async () => {
        const ref = React.createRef();
        return new Promise((res) => {
            ReactDOM.render(_jsx(WorkflowDefinitionListEnvelopeView, { ref: ref, channelApi: envelope.channelApi }), args.container, () => res(() => ref.current));
        });
    };
    const context = {};
    return envelope.start(envelopeViewDelegate, context, {
        create: (apiFactoryArgs) => new WorkflowDefinitionListEnvelopeApiImpl(apiFactoryArgs),
    });
}
//# sourceMappingURL=WorkflowDefinitionListEnvelope.js.map