import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useState } from "react";
import { ToolbarFilter, ToolbarGroup, ToolbarItem, ToolbarToggleGroup, Toolbar, ToolbarContent, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { FilterIcon } from "@patternfly/react-icons/dist/js/icons/filter-icon";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import remove from "lodash/remove";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
var Category;
(function (Category) {
    Category["PROCESS_NAME"] = "Workflow name";
})(Category || (Category = {}));
const WorkflowDefinitionListToolbar = ({ applyFilter, filterWorkflowNames, setFilterWorkflowNames, onOpenTriggerCloudEvent, ouiaSafe, ouiaId, doRefresh, }) => {
    const [workflowNameInput, setWorkflowNameInput] = useState("");
    const doResetFilter = () => {
        applyFilter();
        setFilterWorkflowNames([]);
    };
    const onEnterClicked = (event) => {
        if (event.key === "Enter") {
            workflowNameInput.length > 0 && doApplyFilter();
        }
    };
    const onDeleteFilterGroup = (categoryName, value) => {
        const newfilterWorkflowNames = [...filterWorkflowNames];
        if (categoryName === Category.PROCESS_NAME) {
            remove(newfilterWorkflowNames, (status) => {
                return status === value;
            });
            setFilterWorkflowNames(newfilterWorkflowNames);
            applyFilter();
        }
    };
    const doApplyFilter = () => {
        const newWorkflowNames = [...filterWorkflowNames];
        if (workflowNameInput && !newWorkflowNames.includes(workflowNameInput)) {
            newWorkflowNames.push(workflowNameInput);
            setFilterWorkflowNames(newWorkflowNames);
        }
        setWorkflowNameInput("");
        applyFilter();
    };
    const toggleGroupItems = (_jsx(React.Fragment, { children: _jsxs(ToolbarGroup, { variant: "filter-group", children: [_jsx(ToolbarFilter, { chips: filterWorkflowNames, deleteChip: onDeleteFilterGroup, categoryName: Category.PROCESS_NAME, children: _jsx(InputGroup, { children: _jsx(TextInput, { name: "workflowName", id: "workflowName", type: "search", "aria-label": "workflow name", onChange: setWorkflowNameInput, onKeyPress: onEnterClicked, placeholder: `Filter by workflow name`, value: workflowNameInput, "data-testid": "workflow-filter-input" }) }) }, "input-workflow-name"), _jsx(ToolbarItem, { children: _jsx(Button, { id: "apply-filter", variant: "primary", onClick: doApplyFilter, "data-testid": "apply-filter", children: "Apply Filter" }) })] }) }));
    const toolbarItems = (_jsxs(React.Fragment, { children: [_jsx(ToolbarToggleGroup, { toggleIcon: _jsx(FilterIcon, {}), breakpoint: "xl", children: toggleGroupItems }), _jsx(ToolbarGroup, { variant: "icon-button-group", children: _jsx(ToolbarItem, { children: _jsx(Tooltip, { content: "Refresh", children: _jsx(Button, { variant: "plain", onClick: doRefresh, id: "refresh", "data-testid": "refresh", children: _jsx(SyncIcon, {}) }) }) }) }), onOpenTriggerCloudEvent && (_jsxs(ToolbarGroup, { children: [_jsx(ToolbarItem, { variant: "separator" }), _jsx(ToolbarItem, { children: _jsx(Button, { variant: "primary", onClick: () => onOpenTriggerCloudEvent(), children: "Trigger Cloud Event" }, "triggerCloudEventButton") })] }))] }));
    return (_jsx(Toolbar, { id: "workflow-definition-list-with-filter", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "xl", clearAllFilters: doResetFilter, clearFiltersButtonText: "Reset to default", ...componentOuiaProps(ouiaId, "workflow-definition-list-toolbar", ouiaSafe), children: _jsx(ToolbarContent, { children: toolbarItems }) }));
};
export default WorkflowDefinitionListToolbar;
//# sourceMappingURL=WorkflowDefinitionListToolbar.js.map