import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useImperativeHandle, useState } from "react";
import WorkflowDetails from "./components/WorkflowDetails/WorkflowDetails";
import WorkflowDetailsEnvelopeViewDriver from "./WorkflowDetailsEnvelopeViewDriver";
export const WorkflowDetailsEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [workflowInstance, setWorkflowInstance] = useState({});
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initArgs) => {
            setWorkflowInstance(initArgs.workflowInstance);
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (_jsx(React.Fragment, { children: _jsx(WorkflowDetails, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new WorkflowDetailsEnvelopeViewDriver(props.channelApi), workflowDetails: workflowInstance }) }));
});
export default WorkflowDetailsEnvelopeView;
//# sourceMappingURL=WorkflowDetailsEnvelopeView.js.map