import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { BanIcon } from "@patternfly/react-icons/dist/js/icons/ban-icon";
import { OnRunningIcon } from "@patternfly/react-icons/dist/js/icons/on-running-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { PausedIcon } from "@patternfly/react-icons/dist/js/icons/paused-icon";
import { ErrorCircleOIcon } from "@patternfly/react-icons/dist/js/icons/error-circle-o-icon";
import { WorkflowInstanceState } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
export const WorkflowInstanceIconCreator = (state) => {
    switch (state) {
        case WorkflowInstanceState.Active:
            return (_jsxs(_Fragment, { children: [_jsx(OnRunningIcon, { className: "pf-u-mr-sm" }), "Active"] }));
        case WorkflowInstanceState.Completed:
            return (_jsxs(_Fragment, { children: [_jsx(CheckCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--success-color--100)" }), "Completed"] }));
        case WorkflowInstanceState.Aborted:
            return (_jsxs(_Fragment, { children: [_jsx(BanIcon, { className: "pf-u-mr-sm" }), "Aborted"] }));
        case WorkflowInstanceState.Suspended:
            return (_jsxs(_Fragment, { children: [_jsx(PausedIcon, { className: "pf-u-mr-sm" }), "Suspended"] }));
        case WorkflowInstanceState.Error:
            return (_jsxs(_Fragment, { children: [_jsx(ErrorCircleOIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }), "Error"] }));
    }
};
export const getWorkflowInstanceDescription = (workflowInstance) => {
    return {
        id: workflowInstance.id,
        name: workflowInstance.processName,
        description: workflowInstance.businessKey,
    };
};
export const alterOrderByObj = (orderByObj) => {
    if (orderByObj["id"]) {
        orderByObj["workflowName"] = orderByObj["id"];
        delete orderByObj["id"];
    }
    else if (orderByObj["status"]) {
        orderByObj["state"] = orderByObj["status"];
        delete orderByObj["status"];
    }
    else if (orderByObj["created"]) {
        orderByObj["start"] = orderByObj["created"];
        delete orderByObj["created"];
    }
    return orderByObj;
};
export const checkWorkflowInstanceState = (workflowInstance) => {
    var _a;
    if ((workflowInstance.state === WorkflowInstanceState.Error ||
        workflowInstance.state === WorkflowInstanceState.Active ||
        workflowInstance.state === WorkflowInstanceState.Suspended) &&
        ((_a = workflowInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) &&
        workflowInstance.serviceUrl) {
        return false;
    }
    else {
        return true;
    }
};
export const formatForBulkListWorkflowInstance = (workflowInstanceList) => {
    const formattedItems = [];
    workflowInstanceList.forEach((item) => {
        const formattedObj = {
            id: item.id,
            description: item.businessKey,
            name: item.processName,
            errorMessage: item.errorMessage ? item.errorMessage : undefined,
        };
        formattedItems.push(formattedObj);
    });
    return formattedItems;
};
export const workflowListDefaultStatusFilter = [
    WorkflowInstanceState.Aborted,
    WorkflowInstanceState.Active,
    WorkflowInstanceState.Completed,
    WorkflowInstanceState.Error,
    WorkflowInstanceState.Suspended,
];
//# sourceMappingURL=WorkflowListUtils.js.map