"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeKieEditorController = void 0;
var vscode = require("vscode");
var vscode_1 = require("vscode");
var api_1 = require("@kie-tools-core/editor/dist/api");
var channel_1 = require("@kie-tools-core/envelope-bus/dist/channel");
var __path = require("path");
var workspaceRoot_1 = require("./workspace/workspaceRoot");
function fileExtension(documentUri) {
    var lastSlashIndex = documentUri.fsPath.lastIndexOf("/");
    var fileName = documentUri.fsPath.substring(lastSlashIndex + 1);
    var firstDotIndex = fileName.indexOf(".");
    var fileExtension = fileName.substring(firstDotIndex + 1);
    return fileExtension;
}
var decoder = new TextDecoder("utf-8");
var VsCodeKieEditorController = (function () {
    function VsCodeKieEditorController(document, panel, context, editorStore, envelopeMapping, envelopeLocator, messageBroadcaster, envelopeServer) {
        if (envelopeServer === void 0) { envelopeServer = new channel_1.EnvelopeServer({
            postMessage: function (msg) {
                try {
                    _this.panel.webview.postMessage(msg);
                }
                catch (e) {
                }
            },
        }, envelopeLocator.targetOrigin, function (self) {
            var _a, _b, _c;
            return self.envelopeApi.requests.kogitoEditor_initRequest({ origin: self.origin, envelopeServerId: self.id }, {
                fileExtension: fileExtension(document.document.uri),
                resourcesPathPrefix: envelopeMapping.resourcesPathPrefix,
                initialLocale: vscode.env.language,
                isReadOnly: false,
                channel: vscode.env.uiKind === vscode_1.UIKind.Desktop ? api_1.ChannelType.VSCODE_DESKTOP : api_1.ChannelType.VSCODE_WEB,
                workspaceRootAbsolutePosixPath: (_c = (_b = (_a = vscode.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.uri.path) !== null && _c !== void 0 ? _c : __path.dirname(document.document.uri.path),
            });
        }); }
        var _this = this;
        this.document = document;
        this.panel = panel;
        this.context = context;
        this.editorStore = editorStore;
        this.envelopeMapping = envelopeMapping;
        this.envelopeLocator = envelopeLocator;
        this.messageBroadcaster = messageBroadcaster;
        this.envelopeServer = envelopeServer;
    }
    VsCodeKieEditorController.prototype.getEditorThemeByVscodeTheme = function (vscodeTheme) {
        switch (vscodeTheme) {
            case vscode_1.ColorThemeKind.Dark:
                return api_1.EditorTheme.DARK;
            case vscode_1.ColorThemeKind.HighContrast:
                return api_1.EditorTheme.HIGH_CONTRAST;
            case vscode_1.ColorThemeKind.HighContrastLight:
                return api_1.EditorTheme.HIGH_CONTRAST_LIGHT;
            default:
                return api_1.EditorTheme.LIGHT;
        }
    };
    VsCodeKieEditorController.prototype.getCurrentTheme = function () {
        return this.getEditorThemeByVscodeTheme(vscode.window.activeColorTheme.kind);
    };
    VsCodeKieEditorController.prototype.getContent = function () {
        return this.envelopeServer.envelopeApi.requests.kogitoEditor_contentRequest().then(function (c) { return c.content; });
    };
    VsCodeKieEditorController.prototype.setContent = function (normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        return this.envelopeServer.envelopeApi.requests.kogitoEditor_contentChanged({ normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot, content: content }, { showLoadingOverlay: true });
    };
    VsCodeKieEditorController.prototype.undo = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.envelopeServer.envelopeApi.notifications.kogitoEditor_editorUndo.send();
                return [2];
            });
        });
    };
    VsCodeKieEditorController.prototype.redo = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.envelopeServer.envelopeApi.notifications.kogitoEditor_editorRedo.send();
                return [2];
            });
        });
    };
    VsCodeKieEditorController.prototype.getPreview = function () {
        return this.envelopeServer.envelopeApi.requests.kogitoEditor_previewRequest();
    };
    VsCodeKieEditorController.prototype.validate = function () {
        return this.envelopeServer.envelopeApi.requests.kogitoEditor_validate();
    };
    VsCodeKieEditorController.prototype.setTheme = function (theme) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.envelopeServer.shared.kogitoEditor_theme.set(theme)];
            });
        });
    };
    VsCodeKieEditorController.prototype.startInitPolling = function (apiImpl) {
        this.envelopeServer.startInitPolling(apiImpl);
    };
    VsCodeKieEditorController.prototype.startListening = function (apiImpl) {
        var _this = this;
        this.broadcastSubscription = this.messageBroadcaster.subscribe(function (msg) {
            _this.envelopeServer.receive(msg, apiImpl);
        });
        this.context.subscriptions.push(this.panel.webview.onDidReceiveMessage(function (msg) { return _this.messageBroadcaster.broadcast(msg); }, this, this.context.subscriptions));
    };
    VsCodeKieEditorController.prototype.setupPanelActiveStatusChange = function () {
        var _this = this;
        this.panel.onDidChangeViewState(function () {
            if (_this.panel.active) {
                _this.editorStore.setActive(_this);
            }
            if (!_this.panel.active && _this.editorStore.isActive(_this)) {
                _this.editorStore.setNoneActive();
            }
        }, this, this.context.subscriptions);
    };
    VsCodeKieEditorController.prototype.setupPanelOnDidDispose = function () {
        var _this = this;
        this.panel.onDidDispose(function () {
            _this.envelopeServer.stopInitPolling();
            _this.editorStore.close(_this);
            _this.messageBroadcaster.unsubscribe(_this.broadcastSubscription);
        }, this, this.context.subscriptions);
    };
    VsCodeKieEditorController.prototype.close = function () {
        this.panel.dispose();
    };
    VsCodeKieEditorController.prototype.hasUri = function (uri) {
        return this.document.document.uri === uri;
    };
    VsCodeKieEditorController.prototype.isActive = function () {
        return this.panel.active;
    };
    VsCodeKieEditorController.prototype.setupWebviewContent = function () {
        var _a;
        if (this.envelopeMapping.envelopeContent.type === api_1.EnvelopeContentType.PATH) {
            this.panel.webview.html = "\n          <!DOCTYPE html>\n          <html lang=\"en\">\n          <head>\n              <style>\n                  html, body, div#envelope-app {\n                      margin: 0;\n                      border: 0;\n                      padding: 0;\n                      overflow: hidden;\n                      height: 100%;\n                  }\n                  .panel-heading.uf-listbar-panel-header span {\n                      color: white !important;\n                  }\n                  body {\n                      background-color: #fff !important\n                  }\n              </style>\n\n              <title></title>\n              <meta charset=\"UTF-8\">\n              <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n              <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n          </head>\n          <body>\n          <div id=\"envelope-app\"></div>\n          <script src=\"".concat((_a = this.envelopeMapping.envelopeContent) === null || _a === void 0 ? void 0 : _a.path, "\"></script>\n          </body>\n          </html>\n      ");
        }
    };
    VsCodeKieEditorController.prototype.startListeningToThemeChanges = function () {
        var _this = this;
        var changeThemeSubscription = vscode.window.onDidChangeActiveColorTheme(function (colorTheme) {
            return _this.setTheme(_this.getEditorThemeByVscodeTheme(colorTheme.kind));
        });
        this.panel.onDidDispose(function () {
            changeThemeSubscription.dispose();
        });
    };
    VsCodeKieEditorController.prototype.stopListeningToDocumentChanges = function () {
        var _a;
        (_a = this.changeDocumentSubscription) === null || _a === void 0 ? void 0 : _a.dispose();
        this.changeDocumentSubscription = undefined;
    };
    VsCodeKieEditorController.prototype.startListeningToDocumentChanges = function () {
        var _this = this;
        var _a;
        (_a = this.changeDocumentSubscription) === null || _a === void 0 ? void 0 : _a.dispose();
        this.changeDocumentSubscription = vscode.workspace.onDidChangeTextDocument(function (e) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (e.document.uri.toString() !== this.document.document.uri.toString()) {
                    return [2];
                }
                if (e.contentChanges.length <= 0) {
                    return [2];
                }
                this.envelopeServer.envelopeApi.requests.kogitoEditor_contentChanged({
                    content: e.document.getText(),
                    normalizedPosixPathRelativeToTheWorkspaceRoot: __path.posix.normalize(__path.relative((0, workspaceRoot_1.getWorkspaceRoot)(e.document).workspaceRootAbsoluteFsPath, e.document.uri.fsPath)),
                }, { showLoadingOverlay: false });
                return [2];
            });
        }); });
        this.panel.onDidDispose(function () {
            var _a;
            (_a = _this.changeDocumentSubscription) === null || _a === void 0 ? void 0 : _a.dispose();
        });
    };
    VsCodeKieEditorController.prototype.getDocumentContent = function () {
        return __awaiter(this, void 0, void 0, function () {
            var fileUri, contentArray;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!(this.document.type === "custom")) return [3, 2];
                        fileUri = (_a = this.document.document.initialBackup) !== null && _a !== void 0 ? _a : this.document.document.uri;
                        return [4, vscode.workspace.fs.readFile(fileUri)];
                    case 1:
                        contentArray = _b.sent();
                        return [2, decoder.decode(contentArray)];
                    case 2:
                        if (this.document.type === "text") {
                            return [2, this.document.document.getText()];
                        }
                        throw new Error("Document type not supported");
                }
            });
        });
    };
    return VsCodeKieEditorController;
}());
exports.VsCodeKieEditorController = VsCodeKieEditorController;
//# sourceMappingURL=VsCodeKieEditorController.js.map