import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStatePrimary, EmptyStateSecondaryActions, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { CubesIcon } from "@patternfly/react-icons/dist/js/icons/cubes-icon";
import { PasteIcon } from "@patternfly/react-icons/dist/js/icons/paste-icon";
import { useSettings } from "../settings/DmnEditorSettingsContext";
import { ImportJavaClassesWrapper } from "./ImportJavaClasses";
export function DataTypesEmptyState({ onAdd, onPaste }) {
    const { isReadOnly, isImportDataTypesFromJavaClassesSupported, javaCodeCompletionService } = useSettings();
    return (_jsx(Flex, { justifyContent: { default: "justifyContentCenter" }, style: { marginTop: "100px" }, children: _jsxs(EmptyState, { style: { maxWidth: "1280px" }, children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, { size: "lg", headingLevel: "h4", children: `No custom data types have been defined.` }), _jsx(EmptyStateBody, { children: `Data types are referenced in the input and output values for decision tables. Custom data types allow you to reference more complex data types, beyond the simple "default" types.` }), _jsx("br", {}), !isReadOnly && (_jsxs(_Fragment, { children: [_jsx(EmptyStatePrimary, { children: _jsx(Button, { variant: ButtonVariant.primary, onClick: onAdd, children: "Create a custom data type" }) }), _jsx("br", {}), isImportDataTypesFromJavaClassesSupported && javaCodeCompletionService && (_jsxs(_Fragment, { children: ["or", _jsx("br", {}), _jsx("br", {}), _jsx(ImportJavaClassesWrapper, { javaCodeCompletionService: javaCodeCompletionService }), _jsx("br", {}), _jsx("br", {})] })), "or", _jsx(EmptyStateSecondaryActions, { children: _jsx(Button, { variant: ButtonVariant.link, onClick: onPaste, icon: _jsx(PasteIcon, {}), children: "Paste data type" }) })] }))] }) }));
}
//# sourceMappingURL=DataTypesEmptyState.js.map