import { Fragment as _Fragment, jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import { DmnBuiltInDataType, generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { buildFeelQNameFromXmlQName } from "../feel/buildFeelQName";
import { buildXmlQName, parseXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { getXmlNamespaceDeclarationName } from "@kie-tools/dmn-marshaller/dist/xml/xmlNamespaceDeclarations";
import { useDmnEditorStore } from "../store/StoreContext";
import { parseFeelQName } from "../feel/parseFeelQName";
import { builtInFeelTypeNames } from "./BuiltInFeelTypes";
export function TypeRefLabel({ typeRef, relativeToNamespace, isCollection, }) {
    const importsByNamespace = useDmnEditorStore((s) => s.computed(s).importsByNamespace());
    const thisDmn = useDmnEditorStore((s) => s.dmn);
    const feelName = useMemo(() => {
        if (!typeRef) {
            return undefined;
        }
        if (builtInFeelTypeNames.has(typeRef)) {
            return typeRef;
        }
        const parsedFeelQName = parseFeelQName(typeRef);
        const xmlNamespaceName = getXmlNamespaceDeclarationName({
            rootElement: thisDmn.model.definitions,
            namespace: relativeToNamespace !== null && relativeToNamespace !== void 0 ? relativeToNamespace : "",
        });
        const xmlQName = parseXmlQName(buildXmlQName({
            type: "xml-qname",
            prefix: xmlNamespaceName,
            localPart: parsedFeelQName.importName ? parsedFeelQName.localPart : typeRef,
        }));
        if (xmlQName.prefix) {
            return typeRef;
        }
        const fullFeelQName = buildFeelQNameFromXmlQName({
            importsByNamespace,
            relativeToNamespace: thisDmn.model.definitions["@_namespace"],
            model: thisDmn.model.definitions,
            namedElement: {
                "@_id": generateUuid(),
                "@_name": parsedFeelQName.importName ? parsedFeelQName.localPart : typeRef,
            },
            namedElementQName: xmlQName,
        }).full;
        if (parsedFeelQName.importName) {
            if (typeRef !== fullFeelQName) {
                console.warn(`DMN EDITOR: Data Type label was rendered with discrepancy between provided namespace and the FEEL QName. Going with the provided typeRef. (typeRef: '${typeRef}', feelQName: '${fullFeelQName}').`);
            }
            return typeRef;
        }
        return fullFeelQName;
    }, [thisDmn.model.definitions, importsByNamespace, relativeToNamespace, typeRef]);
    return (_jsx("span", { className: "kie-dmn-editor--data-type-label", children: _jsx("i", { children: (typeRef && (_jsxs(_Fragment, { children: [`${feelName !== null && feelName !== void 0 ? feelName : DmnBuiltInDataType.Undefined}`, isCollection && (_jsxs(_Fragment, { children: ["\u00A0", `[]`] }))] }))) || _jsx(_Fragment, { children: isCollection && _jsx(_Fragment, { children: `[]` }) }) }) }));
}
//# sourceMappingURL=TypeRefLabel.js.map