import { parseFeelQName, buildFeelQName } from "../feel/parseFeelQName";
import { builtInFeelTypeNames } from "./BuiltInFeelTypes";
export function resolveTypeRef({ typeRef, namespace, relativeToNamespace, thisDmnsImportsByNamespace, allTopLevelDataTypesByFeelName, externalModelsByNamespace, }) {
    var _a;
    if (!typeRef) {
        return typeRef;
    }
    if (builtInFeelTypeNames.has(typeRef)) {
        return typeRef;
    }
    if (namespace === relativeToNamespace) {
        return typeRef;
    }
    const externalModel = externalModelsByNamespace === null || externalModelsByNamespace === void 0 ? void 0 : externalModelsByNamespace[namespace];
    if ((externalModel === null || externalModel === void 0 ? void 0 : externalModel.type) !== "dmn") {
        throw new Error("DMN EDITOR: Can't find external DMN model for known external Data Type.");
    }
    const parsedTypeRefFeelQName = parseFeelQName(typeRef);
    const possibleNamespaces = [
        ...((_a = externalModel.model.definitions.import) !== null && _a !== void 0 ? _a : []).flatMap((i) => { var _a; return i["@_name"] === ((_a = parsedTypeRefFeelQName.importName) !== null && _a !== void 0 ? _a : "") ? i["@_namespace"] : []; }),
        namespace,
    ];
    return possibleNamespaces.reduce((acc, namespace) => {
        var _a, _b;
        const thisDmnsImport = thisDmnsImportsByNamespace.get(namespace);
        if (!thisDmnsImport) {
            return acc;
        }
        const typeRefQName = buildFeelQName({
            type: "feel-qname",
            importName: thisDmnsImport["@_name"],
            localPart: parsedTypeRefFeelQName.localPart,
        });
        return (_b = (_a = allTopLevelDataTypesByFeelName.get(typeRefQName)) === null || _a === void 0 ? void 0 : _a.feelName) !== null && _b !== void 0 ? _b : acc;
    }, buildFeelQName({
        type: "feel-qname",
        importName: "?",
        localPart: parsedTypeRefFeelQName.localPart,
    }));
}
//# sourceMappingURL=resolveTypeRef.js.map