import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useRef } from "react";
import * as RF from "reactflow";
import { DEFAULT_INTRACTION_WIDTH } from "../maths/DmnMaths";
import { propsHaveSameValuesDeep } from "../memoization/memoization";
import { useIsHovered } from "../useIsHovered";
import { PotentialWaypoint, Waypoints } from "./Waypoints";
import { useAlwaysVisibleEdgeUpdatersAtNodeBorders } from "./useAlwaysVisibleEdgeUpdatersAtNodeBorders";
import { useKieEdgePath } from "./useKieEdgePath";
import { usePotentialWaypointControls } from "./usePotentialWaypointControls";
import { useSettings } from "../../settings/DmnEditorSettingsContext";
export const InformationRequirementPath = React.memo((_props) => {
    const { svgRef, ...props } = _props;
    return (_jsx(_Fragment, { children: _jsx("path", { ref: svgRef, style: { strokeWidth: 1, stroke: "black" }, markerEnd: "url(#closed-arrow)", ...props }) }));
});
export const KnowledgeRequirementPath = React.memo((__props) => {
    const { svgRef, ...props } = __props;
    return (_jsx(_Fragment, { children: _jsx("path", { ref: svgRef, style: { strokeWidth: 1, stroke: "black", strokeDasharray: "5,5" }, markerEnd: "url(#open-arrow)", ...props }) }));
});
export const AuthorityRequirementPath = React.memo((__props) => {
    const { centerToConnectionPoint: center, svgRef, ...props } = __props;
    return (_jsx(_Fragment, { children: _jsx("path", { ref: svgRef, style: { strokeWidth: 1, stroke: "black", strokeDasharray: "5,5" }, markerEnd: center ? `url(#closed-circle-at-center)` : `url(#closed-circle-at-border)`, ...props }) }));
});
export const AssociationPath = React.memo((__props) => {
    var _a;
    const strokeWidth = (_a = __props.strokeWidth) !== null && _a !== void 0 ? _a : 1.5;
    const { svgRef, ...props } = __props;
    return (_jsx(_Fragment, { children: _jsx("path", { ref: svgRef, strokeWidth: strokeWidth, strokeLinecap: "butt", strokeLinejoin: "round", style: { stroke: "black", strokeDasharray: `${strokeWidth},10` }, ...props }) }));
});
export function useEdgeClassName(isConnecting, isDraggingWaypoint) {
    if (isConnecting) {
        return "dimmed";
    }
    if (isDraggingWaypoint) {
        return "dragging-waypoint";
    }
    return "normal";
}
const interactionStrokeProps = {
    strokeOpacity: 1,
    markerEnd: undefined,
    style: undefined,
    className: "react-flow__edge-interaction",
    stroke: "transparent",
    strokeLinecap: "round",
};
export const InformationRequirementEdge = React.memo((props) => {
    var _a, _b, _c, _d;
    const renderCount = useRef(0);
    renderCount.current++;
    const { path, points: waypoints } = useKieEdgePath(props.source, props.target, props.data);
    const interactionPathRef = React.useRef(null);
    const isHovered = useIsHovered(interactionPathRef);
    const settings = useSettings();
    const { onMouseMove, onDoubleClick, potentialWaypoint, isDraggingWaypoint } = usePotentialWaypointControls(waypoints, props.selected, props.id, (_b = (_a = props.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) === null || _b === void 0 ? void 0 : _b.index, interactionPathRef);
    const isConnecting = !!RF.useStore((s) => s.connectionNodeId);
    const className = useEdgeClassName(isConnecting, isDraggingWaypoint);
    useAlwaysVisibleEdgeUpdatersAtNodeBorders(interactionPathRef, props.source, props.target, waypoints);
    return (_jsxs(_Fragment, { children: [_jsx(InformationRequirementPath, { svgRef: interactionPathRef, d: path, ...interactionStrokeProps, className: `${interactionStrokeProps.className} ${className}`, strokeWidth: (_c = props.interactionWidth) !== null && _c !== void 0 ? _c : DEFAULT_INTRACTION_WIDTH, onMouseMove: onMouseMove, onDoubleClick: onDoubleClick, "data-edgetype": "information-requirement", visibility: settings.isReadOnly ? "hidden" : undefined }), _jsx(InformationRequirementPath, { d: path, className: `kie-dmn-editor--edge ${className}` }), !settings.isReadOnly && props.selected && !isConnecting && ((_d = props.data) === null || _d === void 0 ? void 0 : _d.dmnEdge) && (_jsx(Waypoints, { edgeId: props.id, edgeIndex: props.data.dmnEdge.index, waypoints: waypoints, onDragStop: onMouseMove })), !settings.isReadOnly && isHovered && potentialWaypoint && _jsx(PotentialWaypoint, { point: potentialWaypoint.point })] }));
}, propsHaveSameValuesDeep);
export const KnowledgeRequirementEdge = React.memo((props) => {
    var _a, _b, _c, _d;
    const renderCount = useRef(0);
    renderCount.current++;
    const { path, points: waypoints } = useKieEdgePath(props.source, props.target, props.data);
    const interactionPathRef = React.useRef(null);
    const isHovered = useIsHovered(interactionPathRef);
    const settings = useSettings();
    const { onMouseMove, onDoubleClick, potentialWaypoint, isDraggingWaypoint } = usePotentialWaypointControls(waypoints, props.selected, props.id, (_b = (_a = props.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) === null || _b === void 0 ? void 0 : _b.index, interactionPathRef);
    const isConnecting = !!RF.useStore((s) => s.connectionNodeId);
    const className = useEdgeClassName(isConnecting, isDraggingWaypoint);
    useAlwaysVisibleEdgeUpdatersAtNodeBorders(interactionPathRef, props.source, props.target, waypoints);
    return (_jsxs(_Fragment, { children: [_jsx(KnowledgeRequirementPath, { svgRef: interactionPathRef, d: path, ...interactionStrokeProps, className: `${interactionStrokeProps.className} ${className}`, strokeWidth: (_c = props.interactionWidth) !== null && _c !== void 0 ? _c : DEFAULT_INTRACTION_WIDTH, onMouseMove: onMouseMove, onDoubleClick: onDoubleClick, "data-edgetype": "knowledge-requirement", visibility: settings.isReadOnly ? "hidden" : undefined }), _jsx(KnowledgeRequirementPath, { d: path, className: `kie-dmn-editor--edge ${className}` }), !settings.isReadOnly && props.selected && !isConnecting && ((_d = props.data) === null || _d === void 0 ? void 0 : _d.dmnEdge) && (_jsx(Waypoints, { edgeId: props.id, edgeIndex: props.data.dmnEdge.index, waypoints: waypoints, onDragStop: onMouseMove })), !settings.isReadOnly && isHovered && potentialWaypoint && _jsx(PotentialWaypoint, { point: potentialWaypoint.point })] }));
}, propsHaveSameValuesDeep);
export const AuthorityRequirementEdge = React.memo((props) => {
    var _a, _b, _c, _d;
    const renderCount = useRef(0);
    renderCount.current++;
    const { path, points: waypoints } = useKieEdgePath(props.source, props.target, props.data);
    const interactionPathRef = React.useRef(null);
    const isHovered = useIsHovered(interactionPathRef);
    const settings = useSettings();
    const { onMouseMove, onDoubleClick, potentialWaypoint, isDraggingWaypoint } = usePotentialWaypointControls(waypoints, props.selected, props.id, (_b = (_a = props.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) === null || _b === void 0 ? void 0 : _b.index, interactionPathRef);
    const isConnecting = !!RF.useStore((s) => s.connectionNodeId);
    const className = useEdgeClassName(isConnecting, isDraggingWaypoint);
    useAlwaysVisibleEdgeUpdatersAtNodeBorders(interactionPathRef, props.source, props.target, waypoints);
    return (_jsxs(_Fragment, { children: [_jsx(AuthorityRequirementPath, { svgRef: interactionPathRef, d: path, centerToConnectionPoint: false, ...interactionStrokeProps, className: `${interactionStrokeProps.className} ${className}`, strokeWidth: (_c = props.interactionWidth) !== null && _c !== void 0 ? _c : DEFAULT_INTRACTION_WIDTH, onMouseMove: onMouseMove, onDoubleClick: onDoubleClick, "data-edgetype": "authority-requirement", visibility: settings.isReadOnly ? "hidden" : undefined }), _jsx(AuthorityRequirementPath, { d: path, className: `kie-dmn-editor--edge ${className}`, centerToConnectionPoint: false }), !settings.isReadOnly && props.selected && !isConnecting && ((_d = props.data) === null || _d === void 0 ? void 0 : _d.dmnEdge) && (_jsx(Waypoints, { edgeId: props.id, edgeIndex: props.data.dmnEdge.index, waypoints: waypoints, onDragStop: onMouseMove })), !settings.isReadOnly && isHovered && potentialWaypoint && _jsx(PotentialWaypoint, { point: potentialWaypoint.point })] }));
}, propsHaveSameValuesDeep);
export const AssociationEdge = React.memo((props) => {
    var _a, _b, _c, _d;
    const renderCount = useRef(0);
    renderCount.current++;
    const { path, points: waypoints } = useKieEdgePath(props.source, props.target, props.data);
    const interactionPathRef = React.useRef(null);
    const isHovered = useIsHovered(interactionPathRef);
    const settings = useSettings();
    const { onMouseMove, onDoubleClick, potentialWaypoint, isDraggingWaypoint } = usePotentialWaypointControls(waypoints, props.selected, props.id, (_b = (_a = props.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) === null || _b === void 0 ? void 0 : _b.index, interactionPathRef);
    const isConnecting = !!RF.useStore((s) => s.connectionNodeId);
    const className = useEdgeClassName(isConnecting, isDraggingWaypoint);
    useAlwaysVisibleEdgeUpdatersAtNodeBorders(interactionPathRef, props.source, props.target, waypoints);
    return (_jsxs(_Fragment, { children: [_jsx(AssociationPath, { svgRef: interactionPathRef, d: path, ...interactionStrokeProps, className: `${interactionStrokeProps.className} ${className}`, strokeWidth: (_c = props.interactionWidth) !== null && _c !== void 0 ? _c : DEFAULT_INTRACTION_WIDTH, onMouseMove: onMouseMove, onDoubleClick: onDoubleClick, "data-edgetype": "association", visibility: settings.isReadOnly ? "hidden" : undefined }), _jsx(AssociationPath, { d: path, className: `kie-dmn-editor--edge ${className}` }), !settings.isReadOnly && props.selected && !isConnecting && ((_d = props.data) === null || _d === void 0 ? void 0 : _d.dmnEdge) && (_jsx(Waypoints, { edgeId: props.id, edgeIndex: props.data.dmnEdge.index, waypoints: waypoints, onDragStop: onMouseMove })), !settings.isReadOnly && isHovered && potentialWaypoint && _jsx(PotentialWaypoint, { point: potentialWaypoint.point })] }));
}, propsHaveSameValuesDeep);
//# sourceMappingURL=Edges.js.map