import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { deleteEdgeWaypoint } from "../../mutations/deleteEdgeWaypoint";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { drag } from "d3-drag";
import { select } from "d3-selection";
import { useEffect } from "react";
import { repositionEdgeWaypoint } from "../../mutations/repositionEdgeWaypoint";
import { snapPoint } from "../SnapGrid";
export function PotentialWaypoint(props) {
    return _jsx("circle", { className: "kie-dmn-editor--edge-waypoint-potential", r: 5, cx: props.point.x, cy: props.point.y });
}
export function Waypoints(props) {
    return (_jsx(_Fragment, { children: props.waypoints.slice(1, -1).map((p, i) => (_jsx(Waypoint, { onDragStop: props.onDragStop, edgeIndex: props.edgeIndex, edgeId: props.edgeId, point: p, index: i + 1 }, i))) }));
}
export function Waypoint({ edgeId, edgeIndex, index, point, onDragStop, }) {
    const circleRef = React.useRef(null);
    const diagram = useDmnEditorStore((s) => s.diagram);
    const drdIndex = useDmnEditorStore((s) => s.computed(s).getDrdIndex());
    const { setState } = useDmnEditorStoreApi();
    useEffect(() => {
        if (!circleRef.current) {
            return;
        }
        const selection = select(circleRef.current);
        const dragHandler = drag()
            .on("start", () => {
            setState((state) => state.dispatch(state).diagram.setEdgeStatus(edgeId, { draggingWaypoint: true }));
        })
            .on("drag", (e) => {
            setState((state) => {
                repositionEdgeWaypoint({
                    definitions: state.dmn.model.definitions,
                    drdIndex: drdIndex,
                    edgeIndex,
                    waypointIndex: index,
                    waypoint: snapPoint(diagram.snapGrid, { "@_x": e.x, "@_y": e.y }),
                });
            });
        })
            .on("end", (e) => {
            onDragStop(e.sourceEvent);
            setState((state) => state.dispatch(state).diagram.setEdgeStatus(edgeId, { draggingWaypoint: false }));
        });
        selection.call(dragHandler);
        return () => {
            selection.on(".drag", null);
        };
    }, [drdIndex, diagram.snapGrid, edgeId, edgeIndex, index, onDragStop, setState]);
    return (_jsx("circle", { "data-waypointindex": index, ref: circleRef, className: "kie-dmn-editor--diagram-edge-waypoint", cx: point["@_x"], cy: point["@_y"], r: 1, onDoubleClick: (e) => {
            e.preventDefault();
            e.stopPropagation();
            setState((state) => {
                deleteEdgeWaypoint({
                    definitions: state.dmn.model.definitions,
                    drdIndex: drdIndex,
                    edgeIndex,
                    waypointIndex: index,
                });
            });
        } }));
}
//# sourceMappingURL=Waypoints.js.map