import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { useDmnEditorStoreApi } from "../../store/StoreContext";
import { useSettings } from "../../settings/DmnEditorSettingsContext";
export function EditExpressionNodePanel(props) {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    return (_jsx(_Fragment, { children: props.isVisible && (_jsx(Label, { onClick: () => dmnEditorStoreApi.setState((state) => {
                state.dispatch(state).boxedExpressionEditor.open(props.id);
            }), className: "kie-dmn-editor--edit-expression-node-panel", children: settings.isReadOnly ? "View" : "Edit" })) }));
}
//# sourceMappingURL=EditExpressionNodePanel.js.map