import * as React from "react";
import { XmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { UniqueNameIndex } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { DMN15__tNamedElement } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import { Normalized } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { NodeLabelPosition } from "./NodeSvgs";
import { State } from "../../store/Store";
import "./EditableNodeLabel.css";
export type OnEditableNodeLabelChange = (value: string | undefined) => void;
export declare function EditableNodeLabel({ id, namedElement, namedElementQName, isEditing: _isEditing, setEditing: _setEditing, value, onChange, position, truncate, grow, shouldCommitOnBlur, skipValidation, onGetAllUniqueNames, fontCssProperties, setLabelHeight, enableAutoFocusing, }: {
    id?: string;
    shouldCommitOnBlur?: boolean;
    grow?: boolean;
    truncate?: boolean;
    namedElement?: Normalized<DMN15__tNamedElement>;
    namedElementQName?: XmlQName;
    position: NodeLabelPosition;
    isEditing: boolean;
    value: string | undefined;
    setEditing: React.Dispatch<React.SetStateAction<boolean>>;
    onChange: OnEditableNodeLabelChange;
    skipValidation?: boolean;
    onGetAllUniqueNames: (s: State) => UniqueNameIndex;
    fontCssProperties?: React.CSSProperties;
    setLabelHeight?: React.Dispatch<React.SetStateAction<number>>;
    enableAutoFocusing?: boolean;
}): JSX.Element;
export declare function useEditableNodeLabel(id: string | undefined): {
    isEditingLabel: boolean;
    setEditingLabel: React.Dispatch<React.SetStateAction<boolean>>;
    triggerEditing: (event: React.SyntheticEvent<Element, Event>) => void;
    triggerEditingIfEnter: React.KeyboardEventHandler<Element>;
};
//# sourceMappingURL=EditableNodeLabel.d.ts.map