import { findDataTypeById, traverseItemDefinitions, traverseTypeRefedInExpressionHolders, } from "../dataTypes/DataTypeSpec";
import { IdentifiersRefactor } from "@kie-tools/dmn-language-service";
export function renameItemDefinition({ definitions, newName, allDataTypesById, itemDefinitionId, externalDmnModelsByNamespaceMap, shouldRenameReferencedExpressions, }) {
    var _a, _b, _c;
    const dataType = allDataTypesById.get(itemDefinitionId);
    if (!dataType) {
        throw new Error(`DMN MUTATION: Can't rename unnexistent item definition. ID ${itemDefinitionId}`);
    }
    if (dataType.namespace !== definitions["@_namespace"]) {
        throw new Error(`DMN MUTATION: Can't rename an external item definition. ID ${itemDefinitionId}, Namespace: ${dataType.namespace}`);
    }
    const trimmedNewName = newName.trim();
    const { itemDefinition } = findDataTypeById({ definitions, itemDefinitionId: itemDefinitionId, allDataTypesById });
    if (!(dataType === null || dataType === void 0 ? void 0 : dataType.parentId)) {
        traverseItemDefinitions((_a = definitions.itemDefinition) !== null && _a !== void 0 ? _a : [], (item) => {
            var _a;
            if (((_a = item.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text) === itemDefinition["@_name"]) {
                item.typeRef = { __$$text: trimmedNewName };
            }
        });
        (_b = definitions.drgElement) !== null && _b !== void 0 ? _b : (definitions.drgElement = []);
        for (let i = 0; i < definitions.drgElement.length; i++) {
            const element = definitions.drgElement[i];
            if (element.__$$element === "inputData" ||
                element.__$$element === "decision" ||
                element.__$$element === "businessKnowledgeModel" ||
                element.__$$element === "decisionService") {
                if (((_c = element.variable) === null || _c === void 0 ? void 0 : _c["@_typeRef"]) === itemDefinition["@_name"]) {
                    element.variable["@_typeRef"] = trimmedNewName;
                }
                if (element.__$$element === "decision" || element.__$$element === "businessKnowledgeModel") {
                    traverseTypeRefedInExpressionHolders(element, (typeRefed) => {
                        if (typeRefed["@_typeRef"] === itemDefinition["@_name"]) {
                            typeRefed["@_typeRef"] = trimmedNewName;
                        }
                    });
                }
            }
        }
    }
    else {
        if (shouldRenameReferencedExpressions) {
            const identifiersRefactor = new IdentifiersRefactor({
                writeableDmnDefinitions: definitions,
                _readonly_externalDmnModelsByNamespaceMap: externalDmnModelsByNamespaceMap,
            });
            identifiersRefactor.rename({ identifierUuid: itemDefinitionId, newName: trimmedNewName });
        }
    }
    itemDefinition["@_name"] = trimmedNewName;
}
//# sourceMappingURL=renameItemDefinition.js.map