import { buildXmlHref, parseXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
export function repopulateInputDataAndDecisionsOnAllDecisionServices({ definitions, externalModelsByNamespace, }) {
    var _a;
    for (let i = 0; i < ((_a = definitions.drgElement) !== null && _a !== void 0 ? _a : []).length; i++) {
        const drgElement = definitions.drgElement[i];
        if (drgElement.__$$element === "decisionService") {
            repopulateInputDataAndDecisionsOnDecisionService({
                definitions,
                decisionService: drgElement,
                externalModelsByNamespace,
            });
        }
    }
}
export function repopulateInputDataAndDecisionsOnDecisionService({ definitions, decisionService, externalModelsByNamespace, }) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    const inputDatas = new Set([...((_a = decisionService.inputData) !== null && _a !== void 0 ? _a : [])].map((e) => e["@_href"]));
    const inputDecisions = new Set([...((_b = decisionService.inputDecision) !== null && _b !== void 0 ? _b : [])].map((e) => e["@_href"]));
    decisionService.inputData = [];
    decisionService.inputDecision = [];
    const hrefsToDecisionsInsideDecisionService = new Set([
        ...((_c = decisionService.outputDecision) !== null && _c !== void 0 ? _c : []).map((s) => s["@_href"]),
        ...((_d = decisionService.encapsulatedDecision) !== null && _d !== void 0 ? _d : []).map((s) => s["@_href"]),
    ]);
    const requirements = new Map();
    for (const decisionHrefString of hrefsToDecisionsInsideDecisionService) {
        const decisionHref = parseXmlHref(decisionHrefString);
        if (!decisionHref.namespace || decisionHref.namespace === definitions["@_namespace"]) {
            const localDecision = (_e = definitions.drgElement) === null || _e === void 0 ? void 0 : _e.find((drgElement) => drgElement["@_id"] === decisionHref.id);
            if ((localDecision === null || localDecision === void 0 ? void 0 : localDecision.__$$element) !== "decision") {
                throw new Error(`DMN MUTATION: Node inside Decision Service is not a Decision. ID: ${localDecision === null || localDecision === void 0 ? void 0 : localDecision["@_id"]}`);
            }
            ((_f = localDecision.informationRequirement) !== null && _f !== void 0 ? _f : []).forEach((ir) => {
                if (ir.requiredDecision) {
                    requirements.set(ir.requiredDecision["@_href"], "decisionIr");
                }
                else if (ir.requiredInput) {
                    requirements.set(ir.requiredInput["@_href"], "inputDataIr");
                }
            });
        }
        else {
            const externalModel = externalModelsByNamespace === null || externalModelsByNamespace === void 0 ? void 0 : externalModelsByNamespace[decisionHref.namespace];
            if ((externalModel === null || externalModel === void 0 ? void 0 : externalModel.type) !== "dmn") {
                throw new Error(`DMN MUTATION: External model with namespace ${decisionHref.namespace} is not a DMN.`);
            }
            const externalDecision = (_g = externalModel.model.definitions.drgElement) === null || _g === void 0 ? void 0 : _g.find((drgElement) => drgElement["@_id"] === decisionHref.id);
            if ((externalDecision === null || externalDecision === void 0 ? void 0 : externalDecision.__$$element) !== "decision") {
                throw new Error(`DMN MUTATION: Node inside Decision Service is not a Decision. ID: ${externalDecision === null || externalDecision === void 0 ? void 0 : externalDecision["@_id"]}`);
            }
            ((_h = externalDecision.informationRequirement) !== null && _h !== void 0 ? _h : []).forEach((ir) => {
                if (ir.requiredDecision) {
                    const requirementHref = parseXmlHref(ir.requiredDecision["@_href"]);
                    if (requirementHref.namespace) {
                        requirements.set(ir.requiredDecision["@_href"], "decisionIr");
                    }
                    else {
                        requirements.set(buildXmlHref({ namespace: externalModel.model.definitions["@_namespace"], id: requirementHref.id }), "decisionIr");
                    }
                }
                else if (ir.requiredInput) {
                    const requirementHref = parseXmlHref(ir.requiredInput["@_href"]);
                    if (requirementHref.namespace) {
                        requirements.set(ir.requiredInput["@_href"], "inputDataIr");
                    }
                    else {
                        requirements.set(buildXmlHref({ namespace: externalModel.model.definitions["@_namespace"], id: requirementHref.id }), "inputDataIr");
                    }
                }
                else {
                    throw new Error(`DMN MUTATION: Invalid information requirement referenced by external DecisionService: '${externalDecision["@_id"]}'`);
                }
            });
        }
    }
    [...inputDatas].forEach((inputData) => {
        if (!requirements.has(inputData)) {
            inputDatas.delete(inputData);
        }
    });
    [...inputDecisions].forEach((inputDecision) => {
        if (!requirements.has(inputDecision)) {
            inputDecisions.delete(inputDecision);
        }
    });
    requirements.forEach((type, href) => {
        if (type === "decisionIr") {
            inputDecisions.add(href);
        }
        else if (type === "inputDataIr") {
            inputDatas.add(href);
        }
        else {
            throw new Error(`DMN MUTATION: Invalid type of element to be referenced by DecisionService: '${type}'`);
        }
    });
    decisionService.inputData = [...inputDatas].map((iHref) => ({ "@_href": iHref }));
    decisionService.inputDecision = [...inputDecisions].flatMap((dHref) => (hrefsToDecisionsInsideDecisionService.has(dHref) ? [] : { "@_href": dHref }));
}
//# sourceMappingURL=repopulateInputDataAndDecisionsOnDecisionService.js.map