import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { addOrGetDrd } from "./addOrGetDrd";
import { getCentralizedDecisionServiceDividerLine } from "./updateDecisionServiceDividerLine";
export function repositionNode({ definitions, drdIndex, controlWaypointsByEdge, change, }) {
    var _a, _b, _c;
    const { diagramElements } = addOrGetDrd({ definitions, drdIndex });
    const shape = diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements[change.shapeIndex];
    const shapeBounds = shape === null || shape === void 0 ? void 0 : shape["dc:Bounds"];
    if (!shapeBounds) {
        throw new Error("DMN MUTATION: Cannot reposition non-existent shape bounds");
    }
    let deltaX;
    let deltaY;
    if (change.type === "absolute") {
        deltaX = change.position.x - ((_a = shapeBounds === null || shapeBounds === void 0 ? void 0 : shapeBounds["@_x"]) !== null && _a !== void 0 ? _a : 0);
        deltaY = change.position.y - ((_b = shapeBounds === null || shapeBounds === void 0 ? void 0 : shapeBounds["@_y"]) !== null && _b !== void 0 ? _b : 0);
        shapeBounds["@_x"] = change.position.x;
        shapeBounds["@_y"] = change.position.y;
    }
    else if (change.type === "offset") {
        deltaX = change.offset.deltaX;
        deltaY = change.offset.deltaY;
        shapeBounds["@_x"] += change.offset.deltaX;
        shapeBounds["@_y"] += change.offset.deltaY;
    }
    else {
        throw new Error(`DMN MUTATION: Unknown type of node position change '${change.type}'.`);
    }
    const offsetEdges = (args) => {
        var _a;
        for (const edgeIndex of args.edgeIndexes) {
            const edge = diagramElements[edgeIndex];
            if (!edge || !edge["di:waypoint"]) {
                throw new Error("DMN MUTATION: Cannot reposition non-existent edge");
            }
            const isEdgeSelected = change.selectedEdges.indexOf(edge["@_dmnElementRef"]) >= 0;
            const waypointIndexes = switchExpression(args.waypoint, {
                first: isEdgeSelected
                    ? arrayRange(0, edge["di:waypoint"].length - 2)
                    : [0],
                last: isEdgeSelected
                    ? arrayRange(1, edge["di:waypoint"].length - 1)
                    : [edge["di:waypoint"].length - 1],
            });
            controlWaypointsByEdge.set(edgeIndex, (_a = controlWaypointsByEdge.get(edgeIndex)) !== null && _a !== void 0 ? _a : new Set());
            for (const wi of waypointIndexes) {
                const waypointsControl = controlWaypointsByEdge.get(edgeIndex);
                if (waypointsControl.has(wi)) {
                    continue;
                }
                else {
                    waypointsControl.add(wi);
                }
                const w = edge["di:waypoint"][wi];
                w["@_x"] += deltaX;
                w["@_y"] += deltaY;
            }
        }
    };
    offsetEdges({ edgeIndexes: change.sourceEdgeIndexes, waypoint: "first" });
    offsetEdges({ edgeIndexes: change.targetEdgeIndexes, waypoint: "last" });
    if (change.nodeType === NODE_TYPES.decisionService) {
        (_c = shape["dmndi:DMNDecisionServiceDividerLine"]) !== null && _c !== void 0 ? _c : (shape["dmndi:DMNDecisionServiceDividerLine"] = getCentralizedDecisionServiceDividerLine(shapeBounds));
        const w = shape["dmndi:DMNDecisionServiceDividerLine"]["di:waypoint"];
        w[0]["@_x"] += deltaX;
        w[0]["@_y"] += deltaY;
        w[1]["@_x"] += deltaX;
        w[1]["@_y"] += deltaY;
    }
    return {
        delta: {
            x: deltaX,
            y: deltaY,
        },
        newPosition: {
            x: shapeBounds["@_x"],
            y: shapeBounds["@_y"],
        },
    };
}
function arrayRange(start, stop, step = 1) {
    return Array.from({ length: (stop - start) / step + 1 }, (_, index) => start + index * step);
}
//# sourceMappingURL=repositionNode.js.map