export const IN_VIEW_SELECT_PADDING = 12;
export const TABS_HEIGHT = 40;
export function useInViewSelect(ref, self, factor = 1) {
    var _a, _b;
    const reference = ((_a = ref.current) !== null && _a !== void 0 ? _a : document.body).getBoundingClientRect();
    const s = (_b = self.current) === null || _b === void 0 ? void 0 : _b.getBoundingClientRect();
    if (!s) {
        return { maxHeight: undefined, direction: undefined };
    }
    const below = reference.height - (s.y - reference.y + s.height + IN_VIEW_SELECT_PADDING);
    const above = s.y - reference.y - IN_VIEW_SELECT_PADDING - TABS_HEIGHT;
    if (above > below) {
        return { maxHeight: above, direction: "up" };
    }
    else {
        return { maxHeight: below, direction: "down" };
    }
}
//# sourceMappingURL=useInViewSelect.js.map