import { createContext, useContext } from "react";
import { useStoreWithEqualityFn } from "zustand/traditional";
export const DmnEditorStoreApiContext = createContext({});
export function useDmnEditorStore(selector, equalityFn) {
    const store = useContext(DmnEditorStoreApiContext);
    if (store === null) {
        throw new Error("Can't use DMN Editor Store outside of the DmnEditor component.");
    }
    return useStoreWithEqualityFn(store, selector, equalityFn);
}
export function useDmnEditorStoreApi() {
    return useContext(DmnEditorStoreApiContext);
}
//# sourceMappingURL=StoreContext.js.map