import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { AssociationPath, AuthorityRequirementPath, InformationRequirementPath, KnowledgeRequirementPath, } from "../diagram/edges/Edges";
import { EdgeMarkers } from "../diagram/edges/EdgeMarkers";
import { EDGE_TYPES } from "../diagram/edges/EdgeTypes";
import { getSnappedMultiPointAnchoredEdgePath } from "../diagram/edges/getSnappedMultiPointAnchoredEdgePath";
import { InputDataNodeSvg, DecisionNodeSvg, BkmNodeSvg, KnowledgeSourceNodeSvg, DecisionServiceNodeSvg, GroupNodeSvg, TextAnnotationNodeSvg, UnknownNodeSvg, AlternativeInputDataNodeSvg, } from "../diagram/nodes/NodeSvgs";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { useMemo } from "react";
import { assertUnreachable, getDmnFontStyle, getNodeLabelPosition, getNodeShapeFillColor, getNodeShapeStrokeColor, getNodeStyle, } from "../diagram/nodes/NodeStyle";
import { buildFeelQNameFromXmlQName } from "../feel/buildFeelQName";
import { Text } from "@visx/text";
export function DmnDiagramSvg({ nodes, edges, snapGrid, thisDmn, importsByNamespace, isAlternativeInputDataShape, allDataTypesById, allTopLevelItemDefinitionUniqueNames, }) {
    const { nodesSvg, nodesById } = useMemo(() => {
        const nodesById = new Map();
        const nodesSvg = nodes.map((node) => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9;
            const { fontCssProperties: fontStyle, shapeStyle } = getNodeStyle({
                fillColor: getNodeShapeFillColor({
                    dmnStyle: node.data.shape["di:Style"],
                    nodeType: node.type,
                    isEnabled: true,
                }),
                strokeColor: getNodeShapeStrokeColor({ dmnStyle: node.data.shape["di:Style"], isEnabled: true }),
                dmnFontStyle: getDmnFontStyle({ dmnStyle: node.data.shape["di:Style"], isEnabled: true }),
            });
            nodesById.set(node.id, node);
            const { height, width, ...style } = node.style;
            const isCollection = ((_b = (_a = node.data) === null || _a === void 0 ? void 0 : _a.dmnObject) === null || _b === void 0 ? void 0 : _b.__$$element) === "inputData"
                ? (_h = (_g = (_f = allDataTypesById.get((_e = allTopLevelItemDefinitionUniqueNames.get((_d = (_c = node.data.dmnObject.variable) === null || _c === void 0 ? void 0 : _c["@_typeRef"]) !== null && _d !== void 0 ? _d : "")) !== null && _e !== void 0 ? _e : "")) === null || _f === void 0 ? void 0 : _f.itemDefinition) === null || _g === void 0 ? void 0 : _g["@_isCollection"]) !== null && _h !== void 0 ? _h : false
                : ((_k = (_j = node.data) === null || _j === void 0 ? void 0 : _j.dmnObject) === null || _k === void 0 ? void 0 : _k.__$$element) === "decision"
                    ? (_r = (_q = (_p = allDataTypesById.get((_o = allTopLevelItemDefinitionUniqueNames.get((_m = (_l = node.data.dmnObject.variable) === null || _l === void 0 ? void 0 : _l["@_typeRef"]) !== null && _m !== void 0 ? _m : "")) !== null && _o !== void 0 ? _o : "")) === null || _p === void 0 ? void 0 : _p.itemDefinition) === null || _q === void 0 ? void 0 : _q["@_isCollection"]) !== null && _r !== void 0 ? _r : false
                    : false;
            const label = ((_t = (_s = node.data) === null || _s === void 0 ? void 0 : _s.dmnObject) === null || _t === void 0 ? void 0 : _t.__$$element) === "group"
                ? (_y = (_v = (_u = node.data.dmnObject) === null || _u === void 0 ? void 0 : _u["@_label"]) !== null && _v !== void 0 ? _v : (_x = (_w = node.data) === null || _w === void 0 ? void 0 : _w.dmnObject) === null || _x === void 0 ? void 0 : _x["@_name"]) !== null && _y !== void 0 ? _y : "<Empty>"
                : ((_0 = (_z = node.data) === null || _z === void 0 ? void 0 : _z.dmnObject) === null || _0 === void 0 ? void 0 : _0.__$$element) === "textAnnotation"
                    ? (_6 = (_2 = (_1 = node.data.dmnObject) === null || _1 === void 0 ? void 0 : _1["@_label"]) !== null && _2 !== void 0 ? _2 : (_5 = (_4 = (_3 = node.data) === null || _3 === void 0 ? void 0 : _3.dmnObject) === null || _4 === void 0 ? void 0 : _4.text) === null || _5 === void 0 ? void 0 : _5.__$$text) !== null && _6 !== void 0 ? _6 : "<Empty>"
                    : buildFeelQNameFromXmlQName({
                        namedElement: node.data.dmnObject,
                        importsByNamespace,
                        model: thisDmn.model.definitions,
                        namedElementQName: node.data.dmnObjectQName,
                        relativeToNamespace: thisDmn.model.definitions["@_namespace"],
                    }).full;
            return (_jsxs("g", { "data-kie-dmn-node-id": node.id, children: [node.type === NODE_TYPES.inputData &&
                        (isAlternativeInputDataShape ? (_jsx(AlternativeInputDataNodeSvg, { width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y, ...style, ...shapeStyle, isIcon: false, isCollection: isCollection })) : (_jsx(InputDataNodeSvg, { width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y, ...style, ...shapeStyle, isCollection: isCollection }))), node.type === NODE_TYPES.decision && (_jsx(DecisionNodeSvg, { width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y, ...style, ...shapeStyle, isCollection: isCollection, hasHiddenRequirements: (_7 = node.data.hasHiddenRequirements) !== null && _7 !== void 0 ? _7 : false })), node.type === NODE_TYPES.bkm && (_jsx(BkmNodeSvg, { width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y, ...style, ...shapeStyle, hasHiddenRequirements: (_8 = node.data.hasHiddenRequirements) !== null && _8 !== void 0 ? _8 : false })), node.type === NODE_TYPES.knowledgeSource && (_jsx(KnowledgeSourceNodeSvg, { width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y, ...style, ...shapeStyle, hasHiddenRequirements: (_9 = node.data.hasHiddenRequirements) !== null && _9 !== void 0 ? _9 : false })), node.type === NODE_TYPES.decisionService && (_jsx(DecisionServiceNodeSvg, { width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y, showSectionLabels: false, isReadOnly: true, ...style, ...shapeStyle })), node.type === NODE_TYPES.group && (_jsx(GroupNodeSvg, { width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y, ...style, ...shapeStyle })), node.type === NODE_TYPES.textAnnotation && (_jsx(TextAnnotationNodeSvg, { width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y, ...style, ...shapeStyle })), node.type === NODE_TYPES.unknown && (_jsx(UnknownNodeSvg, { width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y, ...style, ...shapeStyle })), _jsx(_Fragment, { children: label.split("\n").map((labelLine, i) => (_jsx(Text, { lineHeight: fontStyle.lineHeight, style: { ...fontStyle }, dy: `calc(1.5em * ${i})`, ...getNodeLabelSvgTextAlignmentProps(node, getNodeLabelPosition({ nodeType: node.type, isAlternativeInputDataShape })), children: labelLine }, i))) })] }, node.id));
        });
        return { nodesSvg, nodesById };
    }, [
        allDataTypesById,
        allTopLevelItemDefinitionUniqueNames,
        importsByNamespace,
        isAlternativeInputDataShape,
        nodes,
        thisDmn.model.definitions,
    ]);
    return (_jsxs(_Fragment, { children: [_jsx(EdgeMarkers, {}), edges.map((e) => {
                var _a, _b, _c, _d, _e, _f, _g;
                const s = nodesById === null || nodesById === void 0 ? void 0 : nodesById.get(e.source);
                const t = nodesById === null || nodesById === void 0 ? void 0 : nodesById.get(e.target);
                const { path } = getSnappedMultiPointAnchoredEdgePath({
                    snapGrid,
                    dmnEdge: (_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge,
                    dmnShapeSource: (_b = e.data) === null || _b === void 0 ? void 0 : _b.dmnShapeSource,
                    dmnShapeTarget: (_c = e.data) === null || _c === void 0 ? void 0 : _c.dmnShapeTarget,
                    sourceNodeBounds: {
                        x: (_d = s === null || s === void 0 ? void 0 : s.positionAbsolute) === null || _d === void 0 ? void 0 : _d.x,
                        y: (_e = s === null || s === void 0 ? void 0 : s.positionAbsolute) === null || _e === void 0 ? void 0 : _e.y,
                        width: s === null || s === void 0 ? void 0 : s.width,
                        height: s === null || s === void 0 ? void 0 : s.height,
                    },
                    targetNodeBounds: {
                        x: (_f = t === null || t === void 0 ? void 0 : t.positionAbsolute) === null || _f === void 0 ? void 0 : _f.x,
                        y: (_g = t === null || t === void 0 ? void 0 : t.positionAbsolute) === null || _g === void 0 ? void 0 : _g.y,
                        width: t === null || t === void 0 ? void 0 : t.width,
                        height: t === null || t === void 0 ? void 0 : t.height,
                    },
                });
                return (_jsxs(React.Fragment, { children: [e.type === EDGE_TYPES.informationRequirement && _jsx(InformationRequirementPath, { d: path }), e.type === EDGE_TYPES.knowledgeRequirement && _jsx(KnowledgeRequirementPath, { d: path }), e.type === EDGE_TYPES.authorityRequirement && (_jsx(AuthorityRequirementPath, { d: path, centerToConnectionPoint: true })), e.type === EDGE_TYPES.association && _jsx(AssociationPath, { d: path })] }, e.id));
            }), nodesSvg] }));
}
const SVG_NODE_LABEL_TEXT_PADDING_ALL = 10;
const SVG_NODE_LABEL_TEXT_ADDITIONAL_PADDING_TOP_LEFT = 8;
export function getNodeLabelSvgTextAlignmentProps(n, labelPosition) {
    switch (labelPosition) {
        case "center-bottom":
            const cbTx = n.position.x + n.width / 2;
            const cbTy = n.position.y + n.height + 4;
            const cbWidth = n.width;
            return {
                verticalAnchor: "start",
                textAnchor: "middle",
                transform: `translate(${cbTx},${cbTy})`,
                width: cbWidth,
            };
        case "center-center":
            const ccTx = n.position.x + n.width / 2;
            const ccTy = n.position.y + n.height / 2;
            const ccWidth = n.width - 2 * SVG_NODE_LABEL_TEXT_PADDING_ALL;
            return {
                verticalAnchor: "middle",
                textAnchor: "middle",
                transform: `translate(${ccTx},${ccTy})`,
                width: ccWidth,
            };
        case "top-center":
            const tcTx = n.position.x + n.width / 2;
            const tcTy = n.position.y + SVG_NODE_LABEL_TEXT_PADDING_ALL;
            const tcWidth = n.width - 2 * SVG_NODE_LABEL_TEXT_PADDING_ALL;
            return {
                verticalAnchor: "start",
                textAnchor: "middle",
                transform: `translate(${tcTx},${tcTy})`,
                width: tcWidth,
            };
        case "center-left":
            const clTx = n.position.x + SVG_NODE_LABEL_TEXT_PADDING_ALL;
            const clTy = n.position.y + n.height / 2;
            const clWidth = n.width - 2 * SVG_NODE_LABEL_TEXT_PADDING_ALL;
            return {
                verticalAnchor: "middle",
                textAnchor: "start",
                transform: `translate(${clTx},${clTy})`,
                width: clWidth,
            };
        case "top-left":
            const tlTx = n.position.x + SVG_NODE_LABEL_TEXT_PADDING_ALL + SVG_NODE_LABEL_TEXT_ADDITIONAL_PADDING_TOP_LEFT;
            const tlTy = n.position.y + SVG_NODE_LABEL_TEXT_PADDING_ALL + SVG_NODE_LABEL_TEXT_ADDITIONAL_PADDING_TOP_LEFT;
            const tlWidth = n.width - 2 * SVG_NODE_LABEL_TEXT_PADDING_ALL - 2 * SVG_NODE_LABEL_TEXT_ADDITIONAL_PADDING_TOP_LEFT;
            return {
                verticalAnchor: "start",
                textAnchor: "start",
                transform: `translate(${tlTx},${tlTy})`,
                width: tlWidth,
            };
        default:
            assertUnreachable(labelPosition);
    }
}
//# sourceMappingURL=DmnDiagramSvg.js.map