import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import JobsManagementContext from "./JobsManagementContext";
import { JobsManagementGatewayApiImpl } from "./JobsManagementGatewayApi";
import { GraphQLJobsManagementQueries } from "./JobsManagementQueries";
export const JobsManagementContextProvider = ({ apolloClient, children }) => {
    const gatewayApi = useMemo(() => new JobsManagementGatewayApiImpl(new GraphQLJobsManagementQueries(apolloClient)), [apolloClient]);
    return _jsx(JobsManagementContext.Provider, { value: gatewayApi, children: children });
};
export default JobsManagementContextProvider;
//# sourceMappingURL=JobsManagementContextProvider.js.map