/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.auth;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.thriftserver.auth.AuthBridgeServer;
import org.apache.livy.thriftserver.auth.CLIServiceProcessorFactory;
import org.apache.livy.thriftserver.auth.LivyDelegationTokenSecretManager;
import org.apache.livy.thriftserver.auth.PlainSaslServer$;
import org.apache.livy.thriftserver.auth.SQLPlainProcessorFactory;
import org.apache.livy.thriftserver.cli.ThriftCLIService;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u00015\u00111\"Q;uQ\u001a\u000b7\r^8ss*\u00111\u0001B\u0001\u0005CV$\bN\u0003\u0002\u0006\r\u0005aA\u000f\u001b:jMR\u001cXM\u001d<fe*\u0011q\u0001C\u0001\u0005Y&4\u0018P\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\ta!\u0003\u0002\u0018\r\t9Aj\\4hS:<\u0007\u0002C\r\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\t\r|gNZ\u000b\u00027A\u0011Q\u0003H\u0005\u0003;\u0019\u0011\u0001\u0002T5ws\u000e{gN\u001a\u0005\t?\u0001\u0011\t\u0011)A\u00057\u0005)1m\u001c8gA!)\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000be\u0001\u0003\u0019A\u000e\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005Y\u0011-\u001e;i)f\u0004Xm\u0015;s+\u0005I\u0003C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u0011a\u0017M\\4\u000b\u00039\nAA[1wC&\u0011\u0001g\u000b\u0002\u0007'R\u0014\u0018N\\4\t\rI\u0002\u0001\u0015!\u0003*\u00031\tW\u000f\u001e5UsB,7\u000b\u001e:!\u0011\u001d!\u0004A1A\u0005\n!\n!\u0002[1e_>\u0004\u0018)\u001e;i\u0011\u00191\u0004\u0001)A\u0005S\u0005Y\u0001.\u00193p_B\fU\u000f\u001e5!\u0011\u001dA\u0004A1A\u0005\ne\nQb]3de\u0016$X*\u00198bO\u0016\u0014X#\u0001\u001e\u0011\u0007=YT(\u0003\u0002=!\t1q\n\u001d;j_:\u0004\"\u0001\n \n\u0005}\u0012!\u0001\t'jmf$U\r\\3hCRLwN\u001c+pW\u0016t7+Z2sKRl\u0015M\\1hKJDa!\u0011\u0001!\u0002\u0013Q\u0014AD:fGJ,G/T1oC\u001e,'\u000f\t\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003E\u0003)\u0019\u0018m\u001d7TKJ4XM]\u000b\u0002\u000bB\u0019qb\u000f$\u0011\u0005\u0011:\u0015B\u0001%\u0003\u0005A\tU\u000f\u001e5Ce&$w-Z*feZ,'\u000f\u0003\u0004K\u0001\u0001\u0006I!R\u0001\fg\u0006\u001cHnU3sm\u0016\u0014\b\u0005C\u0003M\u0001\u0011\u0005Q*A\thKR\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN,\u0012A\u0014\t\u0005\u001fJ#F+D\u0001Q\u0015\t\tV&\u0001\u0003vi&d\u0017BA*Q\u0005\ri\u0015\r\u001d\t\u0003+bs!a\u0004,\n\u0005]\u0003\u0012A\u0002)sK\u0012,g-\u0003\u000213*\u0011q\u000b\u0005\u0005\u00067\u0002!\t\u0001X\u0001\u0014O\u0016$\u0018)\u001e;i)J\fgn\u001d$bGR|'/_\u000b\u0002;B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\niJ\fgn\u001d9peRT!A\u0019\u0005\u0002\rQD'/\u001b4u\u0013\t!wLA\tU)J\fgn\u001d9peR4\u0015m\u0019;pefD3A\u00174u!\ryq-[\u0005\u0003QB\u0011a\u0001\u001e5s_^\u001c\bC\u00016s\u001b\u0005Y'B\u00017n\u0003\u0015awnZ5o\u0015\t\u0019aN\u0003\u0002pa\u0006A1/Z2ve&$\u0018PC\u0001r\u0003\u0015Q\u0017M^1y\u0013\t\u00198N\u0001\bM_\u001eLg.\u0012=dKB$\u0018n\u001c82\u000by!V/!\b2\r\r2(0a\u0005|+\t9\b0F\u0001U\t\u0015IHB1\u0001\u007f\u0005\u0005!\u0016BA>}\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0011Q\u0010E\u0001\u0007i\"\u0014xn^:\u0012\u0007}\f)\u0001E\u0002\u0010\u0003\u0003I1!a\u0001\u0011\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0002\u0002\u000e9\u0019q\"!\u0003\n\u0007\u0005-\u0001#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0011\u0011\u0003\u0002\n)\"\u0014xn^1cY\u0016T1!a\u0003\u0011c!\u0019\u0013QCA\f\u00033ihbA\b\u0002\u0018%\u0011Q\u0010E\u0019\u0006E=\u0001\u00121\u0004\u0002\u0006g\u000e\fG.Y\u0019\u0003M%Dq!!\t\u0001\t\u0003\t\u0019#\u0001\nhKR\fU\u000f\u001e5Qe>\u001cg)Y2u_JLH\u0003BA\u0013\u0003[\u0001B!a\n\u0002*5\t\u0011-C\u0002\u0002,\u0005\u0014\u0011\u0003\u0016)s_\u000e,7o]8s\r\u0006\u001cGo\u001c:z\u0011!\ty#a\bA\u0002\u0005E\u0012aB:feZL7-\u001a\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011q\u0007\u0003\u0002\u0007\rd\u0017.\u0003\u0003\u0002<\u0005U\"\u0001\u0005+ie&4Go\u0011'J'\u0016\u0014h/[2fQ\u0015\tyBZA c\u0019qB+!\u0011\u0002HE21E\u001e>\u0002Dm\f\u0004bIA\u000b\u0003/\t)%`\u0019\u0006E=\u0001\u00121D\u0019\u0003M%Da!a\u0013\u0001\t\u00039\u0018!D4fiJ+Wn\u001c;f+N,'\u000f\u0003\u0004\u0002P\u0001!\ta^\u0001\rO\u0016$\u0018\n]!eIJ,7o\u001d\u0005\u0007\u0003'\u0002A\u0011A<\u0002)\u001d,G/V:fe\u0006+H\u000f['fG\"\fg.[:n\u0011\u001d\t9\u0006\u0001C\u0001\u00033\n!$[:T\u0003Ncu+\u001b;i\u0017\u0016\u0014(-\u001a:ju\u0016$\u0007*\u00193p_B,\"!a\u0017\u0011\u0007=\ti&C\u0002\u0002`A\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002d\u0001!\t!!\u0017\u0002%%\u001c8+Q*M\u0017\u0016\u0014(-\u001a:pgV\u001bXM\u001d\u0005\b\u0003O\u0002A\u0011AA5\u0003U1XM]5gs\u0012+G.Z4bi&|g\u000eV8lK:$2\u0001VA6\u0011\u001d\ti'!\u001aA\u0002Q\u000bq\u0002Z3mK\u001e\fG/[8o)>\\WM\u001c\u0015\u0007\u0003K\n\t(a!\u0011\t=9\u00171\u000f\t\u0005\u0003k\ny(\u0004\u0002\u0002x)!\u0011qGA=\u0015\u0011\ty#a\u001f\u000b\u0007\u0005u\u0004\"\u0001\u0003iSZ,\u0017\u0002BAA\u0003o\u0012\u0001\u0003S5wKN\u000bF*\u0012=dKB$\u0018n\u001c82\ry!\u0016QQAFc\u0019\u0019cO_ADwFB1%!\u0006\u0002\u0018\u0005%U0M\u0003#\u001fA\tY\"M\u0002'\u0003g\u0002")
public class AuthFactory
implements Logging {
    private final LivyConf conf;
    private final String org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr;
    private final String hadoopAuth;
    private final Option<LivyDelegationTokenSecretManager> secretManager;
    private final Option<AuthBridgeServer> saslServer;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        AuthFactory authFactory = this;
        synchronized (authFactory) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public LivyConf conf() {
        return this.conf;
    }

    public String org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr() {
        return this.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr;
    }

    private String hadoopAuth() {
        return this.hadoopAuth;
    }

    private Option<LivyDelegationTokenSecretManager> secretManager() {
        return this.secretManager;
    }

    private Option<AuthBridgeServer> saslServer() {
        return this.saslServer;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getSaslProperties() {
        void var1_1;
        HashMap<String, String> saslProps = new HashMap<String, String>();
        SaslQOP saslQOP = SaslQOP.fromString((String)this.conf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_SASL_QOP()));
        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return var1_1;
    }

    public TTransportFactory getAuthTransFactory() throws LoginException {
        boolean isAuthKerberos = this.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.KERBEROS.getAuthName());
        boolean isAuthNoSASL = this.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.NOSASL.getAuthName());
        boolean isAuthOther = this.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.LDAP.getAuthName()) || this.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.NONE.getAuthName()) || this.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.CUSTOM.getAuthName());
        return (TTransportFactory)this.saslServer().map((Function1)new Serializable(this, isAuthKerberos, isAuthOther){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AuthFactory $outer;
            private final boolean isAuthKerberos$1;
            private final boolean isAuthOther$1;

            public final TTransportFactory apply(AuthBridgeServer server) {
                block4: {
                    try {
                        TSaslServerTransport.Factory serverTransportFactory = server.createSaslServerTransportFactory(this.$outer.getSaslProperties());
                        if (this.isAuthOther$1) {
                            PlainSaslServer$.MODULE$.addPlainServerDefinition(serverTransportFactory, this.$outer.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr(), this.$outer.conf());
                        } else if (!this.isAuthKerberos$1) break block4;
                        return server.wrapTransportFactory((TTransportFactory)serverTransportFactory);
                    }
                    catch (TTransportException tTransportException) {
                        throw new LoginException(tTransportException.getMessage());
                    }
                }
                throw new LoginException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported authentication type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isAuthKerberos$1 = isAuthKerberos$1;
                this.isAuthOther$1 = isAuthOther$1;
            }
        }).getOrElse((Function0)new Serializable(this, isAuthNoSASL, isAuthOther){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AuthFactory $outer;
            private final boolean isAuthNoSASL$1;
            private final boolean isAuthOther$1;

            public final TTransportFactory apply() {
                block4: {
                    TTransportFactory tTransportFactory;
                    block3: {
                        block2: {
                            if (!this.isAuthOther$1) break block2;
                            tTransportFactory = PlainSaslServer$.MODULE$.getPlainTransportFactory(this.$outer.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr(), this.$outer.conf());
                            break block3;
                        }
                        if (!this.isAuthNoSASL$1) break block4;
                        tTransportFactory = new TTransportFactory();
                    }
                    return tTransportFactory;
                }
                throw new LoginException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported authentication type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isAuthNoSASL$1 = isAuthNoSASL$1;
                this.isAuthOther$1 = isAuthOther$1;
            }
        });
    }

    public TProcessorFactory getAuthProcFactory(ThriftCLIService service) throws LoginException {
        return this.saslServer().isDefined() ? new CLIServiceProcessorFactory(service, (AuthBridgeServer)this.saslServer().get()) : new SQLPlainProcessorFactory(service);
    }

    public String getRemoteUser() {
        return (String)this.saslServer().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(AuthBridgeServer x$1) {
                return x$1.getRemoteUser();
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public String getIpAddress() {
        return (String)this.saslServer().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<InetAddress> apply(AuthBridgeServer s) {
                return Option$.MODULE$.apply((Object)s.getRemoteAddress());
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(InetAddress x$2) {
                return x$2.getHostAddress();
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public String getUserAuthMechanism() {
        return (String)this.saslServer().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(AuthBridgeServer x$3) {
                return x$3.getUserAuthMechanism();
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public boolean isSASLWithKerberizedHadoop() {
        return "kerberos".equalsIgnoreCase(this.hadoopAuth()) && !this.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.NOSASL.getAuthName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSASLKerberosUser() {
        String string = SaslRpcServer.AuthMethod.KERBEROS.getMechanismName();
        String string2 = this.getUserAuthMechanism();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = SaslRpcServer.AuthMethod.TOKEN.getMechanismName();
        String string4 = this.getUserAuthMechanism();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public String verifyDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.secretManager().isEmpty()) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            return ((LivyDelegationTokenSecretManager)((Object)this.secretManager().get())).verifyDelegationToken(delegationToken);
        }
        catch (IOException iOException) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error verifying delegation token ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{delegationToken}));
            this.error((Function0<Object>)new Serializable(this, msg){
                public static final long serialVersionUID = 0L;
                private final String msg$1;

                public final String apply() {
                    return this.msg$1;
                }
                {
                    this.msg$1 = msg$1;
                }
            }, iOException);
            throw new HiveSQLException(msg, "08S01", (Throwable)iOException);
        }
    }

    private final void liftedTree1$1(LivyDelegationTokenSecretManager sm$1) {
        try {
            sm$1.startThreads();
            return;
        }
        catch (IOException iOException) {
            throw new TTransportException("Failed to start token manager", (Throwable)iOException);
        }
    }

    public AuthFactory(LivyConf conf) {
        None$ none$;
        this.conf = conf;
        Logging.class.$init$((Logging)this);
        this.org$apache$livy$thriftserver$auth$AuthFactory$$authTypeStr = conf.get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_AUTHENTICATION());
        this.hadoopAuth = new Configuration().get("hadoop.security.authentication");
        if (this.isSASLWithKerberizedHadoop()) {
            LivyDelegationTokenSecretManager sm = new LivyDelegationTokenSecretManager(conf);
            this.liftedTree1$1(sm);
            none$ = new Some((Object)sm);
        } else {
            none$ = None$.MODULE$;
        }
        this.secretManager = none$;
        this.saslServer = this.secretManager().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AuthBridgeServer apply(LivyDelegationTokenSecretManager sm) {
                return new AuthBridgeServer(sm);
            }
        });
    }
}

