/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.speculate;

public class DataStatistics {
    private int count = 0;
    private double sum = 0.0;
    private double sumSquares = 0.0;

    public DataStatistics() {
    }

    public DataStatistics(double initNum) {
        this.count = 1;
        this.sum = initNum;
        this.sumSquares = initNum * initNum;
    }

    public synchronized void add(double newNum) {
        ++this.count;
        this.sum += newNum;
        this.sumSquares += newNum * newNum;
    }

    public synchronized void updateStatistics(double old, double update) {
        this.sum += update - old;
        this.sumSquares += update * update - old * old;
    }

    public synchronized double mean() {
        return this.count == 0 ? 0.0 : this.sum / (double)this.count;
    }

    public synchronized double var() {
        if (this.count <= 1) {
            return 0.0;
        }
        double mean = this.mean();
        return Math.max(this.sumSquares / (double)this.count - mean * mean, 0.0);
    }

    public synchronized double std() {
        return Math.sqrt(this.var());
    }

    public synchronized double outlier(float sigma) {
        if ((double)this.count != 0.0) {
            return this.mean() + this.std() * (double)sigma;
        }
        return 0.0;
    }

    public synchronized double count() {
        return this.count;
    }

    public String toString() {
        return "DataStatistics: count is " + this.count + ", sum is " + this.sum + ", sumSquares is " + this.sumSquares + " mean is " + this.mean() + " std() is " + this.std();
    }
}

