/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.reader.IAlignedPageReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class MemAlignedPageReader
implements IPageReader,
IAlignedPageReader {
    private final IPointReader timeValuePairIterator;
    private final AlignedChunkMetadata chunkMetadata;
    private Filter valueFilter;

    public MemAlignedPageReader(IPointReader timeValuePairIterator, AlignedChunkMetadata chunkMetadata, Filter filter) {
        this.timeValuePairIterator = timeValuePairIterator;
        this.chunkMetadata = chunkMetadata;
        this.valueFilter = filter;
    }

    public BatchData getAllSatisfiedPageData() throws IOException {
        return super.getAllSatisfiedPageData();
    }

    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)TSDataType.VECTOR, (boolean)ascending, (boolean)false);
        while (this.timeValuePairIterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = this.timeValuePairIterator.nextTimeValuePair();
            TsPrimitiveType[] values = timeValuePair.getValue().getVector();
            Object firstNotNullObject = null;
            for (TsPrimitiveType value : values) {
                if (value == null) continue;
                firstNotNullObject = value.getValue();
                break;
            }
            if (firstNotNullObject == null || this.valueFilter != null && !this.valueFilter.satisfy(timeValuePair.getTimestamp(), firstNotNullObject)) continue;
            batchData.putVector(timeValuePair.getTimestamp(), values);
        }
        return batchData.flip();
    }

    public Statistics getStatistics() {
        return this.chunkMetadata.getStatistics();
    }

    public Statistics getStatistics(int index) {
        return this.chunkMetadata.getStatistics(index);
    }

    public Statistics getTimeStatistics() {
        return this.chunkMetadata.getTimeStatistics();
    }

    public void setFilter(Filter filter) {
        this.valueFilter = this.valueFilter == null ? filter : new AndFilter(this.valueFilter, filter);
    }

    public boolean isModified() {
        return false;
    }
}

