/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils.nodetool.function;

import io.airlift.airline.Command;
import java.util.Map;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitorMBean;
import org.apache.iotdb.cluster.utils.nodetool.Printer;
import org.apache.iotdb.cluster.utils.nodetool.function.NodeToolCmd;

@Command(name="migration", description="Print information about how many slots are in the state of data migration for each data group. ")
public class Migration
extends NodeToolCmd {
    @Override
    public void execute(ClusterMonitorMBean proxy) {
        try {
            Map<PartitionGroup, Integer> groupSlotsMap = proxy.getSlotNumInDataMigration();
            if (groupSlotsMap == null) {
                Printer.msgPrintln("Fail to get all slot status, please check node status and try again later.");
                return;
            }
            if (groupSlotsMap.isEmpty()) {
                Printer.msgPrintln("No slots are in the state of data migration, users can change membership.");
            } else {
                Printer.msgPrintln("Some slots are in the state of data migration, users can not change membership until the end of data migration:");
                Printer.msgPrintln(String.format("%-20s  %30s", "Slot num", "Data Group"));
                for (Map.Entry<PartitionGroup, Integer> entry : groupSlotsMap.entrySet()) {
                    PartitionGroup group = entry.getKey();
                    Printer.msgPrintln(String.format("%-20d->%30s", entry.getValue(), Migration.partitionGroupToString(group)));
                }
            }
        }
        catch (LeaderUnknownException e) {
            Printer.msgPrintln("Meta group leader is unknown, please try again later.");
        }
        catch (Exception e) {
            Printer.msgPrintln(e.getMessage());
        }
    }
}

