/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;

public class PartiteGraphReplicationRegionGroupAllocator
implements IRegionGroupAllocator {
    private static final Random RANDOM = new Random();
    private static final GreedyRegionGroupAllocator GREEDY_ALLOCATOR = new GreedyRegionGroupAllocator();
    private int subGraphCount;
    private int replicationFactor;
    private int regionPerDataNode;
    private int dataNodeNum;
    private int[] regionCounter;
    private int[][] combinationCounter;
    private Map<Integer, Integer> fakeToRealIdMap;
    private int alphaDataNodeNum;
    private int optimalEdgeSum;
    private int optimalRegionSum;
    private int[] optimalAlphaNodes;

    @Override
    public TRegionReplicaSet generateOptimalRegionReplicasDistribution(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Double> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups, List<TRegionReplicaSet> databaseAllocatedRegionGroups, int replicationFactor, TConsensusGroupId consensusGroupId) {
        int i;
        this.regionPerDataNode = consensusGroupId.getType().equals((Object)TConsensusGroupType.DataRegion) ? ConfigNodeDescriptor.getInstance().getConf().getDataRegionPerDataNode() : ConfigNodeDescriptor.getInstance().getConf().getSchemaRegionPerDataNode();
        this.prepare(replicationFactor, availableDataNodeMap, allocatedRegionGroups);
        for (int i2 = 0; i2 < this.subGraphCount; ++i2) {
            this.subGraphSearch(i2, 0, this.alphaDataNodeNum, 0, 0, new int[this.alphaDataNodeNum]);
        }
        if (this.optimalEdgeSum == Integer.MAX_VALUE) {
            return GREEDY_ALLOCATOR.generateOptimalRegionReplicasDistribution(availableDataNodeMap, freeDiskSpaceMap, allocatedRegionGroups, databaseAllocatedRegionGroups, replicationFactor, consensusGroupId);
        }
        List<Integer> partiteNodes = this.partiteGraphSearch(this.optimalAlphaNodes[0] % this.subGraphCount);
        if (partiteNodes.size() < replicationFactor - this.alphaDataNodeNum) {
            return GREEDY_ALLOCATOR.generateOptimalRegionReplicasDistribution(availableDataNodeMap, freeDiskSpaceMap, allocatedRegionGroups, databaseAllocatedRegionGroups, replicationFactor, consensusGroupId);
        }
        TRegionReplicaSet result = new TRegionReplicaSet();
        result.setRegionId(consensusGroupId);
        for (i = 0; i < this.alphaDataNodeNum; ++i) {
            result.addToDataNodeLocations(availableDataNodeMap.get(this.fakeToRealIdMap.get(this.optimalAlphaNodes[i])).getLocation());
        }
        for (i = 0; i < replicationFactor - this.alphaDataNodeNum; ++i) {
            result.addToDataNodeLocations(availableDataNodeMap.get(this.fakeToRealIdMap.get(partiteNodes.get(i))).getLocation());
        }
        return result;
    }

    private void prepare(int replicationFactor, Map<Integer, TDataNodeConfiguration> availableDataNodeMap, List<TRegionReplicaSet> allocatedRegionGroups) {
        int i;
        this.subGraphCount = replicationFactor / 2 + (replicationFactor % 2 == 0 ? 0 : 1);
        this.replicationFactor = replicationFactor;
        this.fakeToRealIdMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> realToFakeIdMap = new TreeMap<Integer, Integer>();
        this.dataNodeNum = availableDataNodeMap.size();
        List dataNodeIdList = availableDataNodeMap.values().stream().map(c -> c.getLocation().getDataNodeId()).collect(Collectors.toList());
        for (i = 0; i < this.dataNodeNum; ++i) {
            this.fakeToRealIdMap.put(i, (Integer)dataNodeIdList.get(i));
            realToFakeIdMap.put((Integer)dataNodeIdList.get(i), i);
        }
        this.regionCounter = new int[this.dataNodeNum];
        Arrays.fill(this.regionCounter, 0);
        this.combinationCounter = new int[this.dataNodeNum][this.dataNodeNum];
        for (i = 0; i < this.dataNodeNum; ++i) {
            Arrays.fill(this.combinationCounter[i], 0);
        }
        for (TRegionReplicaSet regionReplicaSet : allocatedRegionGroups) {
            List dataNodeLocations = regionReplicaSet.getDataNodeLocations();
            for (int i2 = 0; i2 < dataNodeLocations.size(); ++i2) {
                int fakeIId;
                int n = fakeIId = ((Integer)realToFakeIdMap.get(((TDataNodeLocation)dataNodeLocations.get(i2)).getDataNodeId())).intValue();
                this.regionCounter[n] = this.regionCounter[n] + 1;
                for (int j = i2 + 1; j < dataNodeLocations.size(); ++j) {
                    int fakeJId = (Integer)realToFakeIdMap.get(((TDataNodeLocation)dataNodeLocations.get(j)).getDataNodeId());
                    this.combinationCounter[fakeIId][fakeJId] = 1;
                    this.combinationCounter[fakeJId][fakeIId] = 1;
                }
            }
        }
        this.alphaDataNodeNum = replicationFactor / 2 + 1;
        this.optimalEdgeSum = Integer.MAX_VALUE;
        this.optimalRegionSum = Integer.MAX_VALUE;
        this.optimalAlphaNodes = new int[this.alphaDataNodeNum];
    }

    private void subGraphSearch(int firstIndex, int currentReplica, int replicaNum, int combinationSum, int regionSum, int[] currentReplicaSet) {
        if (currentReplica == replicaNum) {
            if (combinationSum < this.optimalEdgeSum || combinationSum == this.optimalEdgeSum && regionSum < this.optimalRegionSum) {
                this.optimalEdgeSum = combinationSum;
                this.optimalRegionSum = regionSum;
                this.optimalAlphaNodes = Arrays.copyOf(currentReplicaSet, this.replicationFactor);
            } else if (combinationSum == this.optimalEdgeSum && regionSum == this.optimalRegionSum && RANDOM.nextBoolean()) {
                this.optimalAlphaNodes = Arrays.copyOf(currentReplicaSet, this.replicationFactor);
            }
            return;
        }
        for (int i = firstIndex; i < this.dataNodeNum; i += this.subGraphCount) {
            if (this.regionCounter[i] >= this.regionPerDataNode) continue;
            int nxtCombinationSum = combinationSum;
            for (int j = 0; j < currentReplica; ++j) {
                nxtCombinationSum += this.combinationCounter[i][currentReplicaSet[j]];
            }
            if (combinationSum > this.optimalEdgeSum) {
                return;
            }
            int nxtRegionSum = regionSum + this.regionCounter[i];
            if (combinationSum == this.optimalEdgeSum && regionSum > this.optimalRegionSum) {
                return;
            }
            currentReplicaSet[currentReplica] = i;
            this.subGraphSearch(i + this.subGraphCount, currentReplica + 1, replicaNum, nxtCombinationSum, nxtRegionSum, currentReplicaSet);
        }
    }

    private List<Integer> partiteGraphSearch(int selected) {
        ArrayList<Integer> partiteNodes = new ArrayList<Integer>();
        for (int partiteIndex = 0; partiteIndex < this.subGraphCount; ++partiteIndex) {
            if (partiteIndex == selected) continue;
            int selectedDataNode = -1;
            int bestScatterWidth = 0;
            int bestRegionSum = Integer.MAX_VALUE;
            for (int i = partiteIndex; i < this.dataNodeNum; i += this.subGraphCount) {
                if (this.regionCounter[i] >= this.regionPerDataNode) continue;
                int scatterWidth = this.alphaDataNodeNum;
                for (int k = 0; k < this.alphaDataNodeNum; ++k) {
                    scatterWidth -= this.combinationCounter[i][this.optimalAlphaNodes[k]];
                }
                if (scatterWidth < bestScatterWidth) continue;
                if (scatterWidth > bestScatterWidth) {
                    bestScatterWidth = scatterWidth;
                    bestRegionSum = this.regionCounter[i];
                    selectedDataNode = i;
                    continue;
                }
                if (this.regionCounter[i] < bestRegionSum) {
                    bestRegionSum = this.regionCounter[i];
                    selectedDataNode = i;
                    continue;
                }
                if (this.regionCounter[i] != bestRegionSum || !RANDOM.nextBoolean()) continue;
                selectedDataNode = i;
            }
            if (selectedDataNode == -1) {
                return new ArrayList<Integer>();
            }
            partiteNodes.add(selectedDataNode);
        }
        return partiteNodes;
    }
}

