/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.subscription;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMetaKeeper;
import org.apache.iotdb.commons.subscription.meta.subscription.SubscriptionMeta;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMetaKeeper;
import org.apache.iotdb.confignode.consensus.request.write.subscription.consumer.AlterConsumerGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.consumer.runtime.ConsumerGroupHandleMetaChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.AlterMultipleTopicsPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.AlterTopicPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.CreateTopicPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.DropTopicPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.runtime.TopicHandleMetaChangePlan;
import org.apache.iotdb.confignode.consensus.response.subscription.SubscriptionTableResp;
import org.apache.iotdb.confignode.consensus.response.subscription.TopicTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TCloseConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TSubscribeReq;
import org.apache.iotdb.confignode.rpc.thrift.TUnsubscribeReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionInfo.class);
    private static final String SNAPSHOT_FILE_NAME = "subscription_info.bin";
    private final TopicMetaKeeper topicMetaKeeper;
    private final ConsumerGroupMetaKeeper consumerGroupMetaKeeper;
    private final ReentrantReadWriteLock subscriptionInfoLock = new ReentrantReadWriteLock(true);
    private final SubscriptionInfoVersion subscriptionInfoVersion;

    public SubscriptionInfo() {
        this.topicMetaKeeper = new TopicMetaKeeper();
        this.consumerGroupMetaKeeper = new ConsumerGroupMetaKeeper();
        this.subscriptionInfoVersion = new SubscriptionInfoVersion();
    }

    private void acquireReadLock() {
        this.subscriptionInfoLock.readLock().lock();
    }

    private void releaseReadLock() {
        this.subscriptionInfoLock.readLock().unlock();
    }

    public void acquireWriteLock() {
        this.subscriptionInfoLock.writeLock().lock();
        this.subscriptionInfoVersion.increaseLatestVersion();
    }

    public void releaseWriteLock() {
        this.subscriptionInfoLock.writeLock().unlock();
    }

    public void updateLastSyncedVersion() {
        this.subscriptionInfoVersion.updateLastSyncedVersion();
    }

    public boolean canSkipNextSync() {
        return this.subscriptionInfoVersion.canSkipNextSync();
    }

    public boolean validateBeforeCreatingTopic(TCreateTopicReq createTopicReq) throws SubscriptionException {
        this.acquireReadLock();
        try {
            boolean bl = this.checkBeforeCreateTopicInternal(createTopicReq);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean checkBeforeCreateTopicInternal(TCreateTopicReq createTopicReq) throws SubscriptionException {
        if (!this.isTopicExisted(createTopicReq.getTopicName())) {
            return true;
        }
        if (createTopicReq.isSetIfNotExistsCondition() && createTopicReq.isIfNotExistsCondition()) {
            return false;
        }
        String exceptionMessage = String.format("Failed to create topic %s, the topic with the same name has been created", createTopicReq.getTopicName());
        LOGGER.warn(exceptionMessage);
        throw new SubscriptionException(exceptionMessage);
    }

    public void validateBeforeDroppingTopic(String topicName) throws SubscriptionException {
        this.acquireReadLock();
        try {
            this.checkBeforeDropTopicInternal(topicName);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeDropTopicInternal(String topicName) throws SubscriptionException {
        TopicMeta topicMeta;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Check before dropping topic: {}, topic exists: {}", (Object)topicName, (Object)this.isTopicExisted(topicName));
        }
        if (Objects.isNull(topicMeta = this.topicMetaKeeper.getTopicMeta(topicName))) {
            return;
        }
        if (!this.consumerGroupMetaKeeper.isTopicSubscribedByConsumerGroup(topicName)) {
            return;
        }
        String exceptionMessage = String.format("Failed to drop topic %s, the topic is subscribed by some consumers", topicMeta.getTopicName());
        LOGGER.warn(exceptionMessage);
        throw new SubscriptionException(exceptionMessage);
    }

    public void validatePipePluginUsageByTopic(String pipePluginName) throws SubscriptionException {
        this.acquireReadLock();
        try {
            this.validatePipePluginUsageByTopicInternal(pipePluginName);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void validatePipePluginUsageByTopicInternal(String pipePluginName) throws SubscriptionException {
        this.acquireReadLock();
        try {
            this.topicMetaKeeper.getAllTopicMeta().forEach(meta -> {
                if (pipePluginName.equals(meta.getConfig().getAttribute().get("processor"))) {
                    String exceptionMessage = String.format("PipePlugin '%s' is already used by Topic '%s' as a processor.", pipePluginName, meta.getTopicName());
                    LOGGER.warn(exceptionMessage);
                    throw new SubscriptionException(exceptionMessage);
                }
            });
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void validateBeforeAlteringTopic(TopicMeta topicMeta) throws SubscriptionException {
        this.acquireReadLock();
        try {
            this.checkBeforeAlteringTopicInternal(topicMeta);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeAlteringTopicInternal(TopicMeta topicMeta) throws SubscriptionException {
        if (this.isTopicExisted(topicMeta.getTopicName())) {
            return;
        }
        String exceptionMessage = String.format("Failed to alter topic %s, the topic is not existed", topicMeta.getTopicName());
        LOGGER.warn(exceptionMessage);
        throw new SubscriptionException(exceptionMessage);
    }

    public boolean isTopicExisted(String topicName) {
        this.acquireReadLock();
        try {
            boolean bl = this.topicMetaKeeper.containsTopicMeta(topicName);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public TopicMeta getTopicMeta(String topicName) {
        this.acquireReadLock();
        try {
            TopicMeta topicMeta = this.topicMetaKeeper.getTopicMeta(topicName);
            return topicMeta;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public Iterable<TopicMeta> getAllTopicMeta() {
        this.acquireReadLock();
        try {
            Iterable iterable = this.topicMetaKeeper.getAllTopicMeta();
            return iterable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public TopicMeta deepCopyTopicMeta(String topicName) {
        this.acquireReadLock();
        try {
            TopicMeta topicMeta = this.topicMetaKeeper.containsTopicMeta(topicName) ? this.topicMetaKeeper.getTopicMeta(topicName).deepCopy() : null;
            return topicMeta;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public DataSet showTopics() {
        this.acquireReadLock();
        try {
            TopicTableResp topicTableResp = new TopicTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), StreamSupport.stream(this.topicMetaKeeper.getAllTopicMeta().spliterator(), false).collect(Collectors.toList()));
            return topicTableResp;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public TSStatus createTopic(CreateTopicPlan plan) {
        this.acquireWriteLock();
        try {
            this.topicMetaKeeper.addTopicMeta(plan.getTopicMeta().getTopicName(), plan.getTopicMeta());
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public TSStatus alterTopic(AlterTopicPlan plan) {
        this.acquireWriteLock();
        try {
            this.topicMetaKeeper.removeTopicMeta(plan.getTopicMeta().getTopicName());
            this.topicMetaKeeper.addTopicMeta(plan.getTopicMeta().getTopicName(), plan.getTopicMeta());
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus alterMultipleTopics(AlterMultipleTopicsPlan plan) {
        this.acquireWriteLock();
        try {
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            status.setSubStatus(new ArrayList());
            for (AlterTopicPlan subPlan : plan.getSubPlans()) {
                TSStatus innerStatus = this.alterTopic(subPlan);
                status.getSubStatus().add(innerStatus);
                if (innerStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                status.setCode(TSStatusCode.ALTER_TOPIC_ERROR.getStatusCode());
                break;
            }
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                status.setSubStatus(null);
            }
            TSStatus tSStatus = status;
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public TSStatus dropTopic(DropTopicPlan plan) {
        this.acquireWriteLock();
        try {
            this.topicMetaKeeper.removeTopicMeta(plan.getTopicName());
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public TSStatus handleTopicMetaChanges(TopicHandleMetaChangePlan plan) {
        this.acquireWriteLock();
        try {
            LOGGER.info("Handling topic meta changes ...");
            this.topicMetaKeeper.clear();
            plan.getTopicMetaList().forEach(topicMeta -> {
                this.topicMetaKeeper.addTopicMeta(topicMeta.getTopicName(), topicMeta);
                LOGGER.info("Recording topic meta: {}", topicMeta);
            });
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void validateBeforeCreatingConsumer(TCreateConsumerReq createConsumerReq) throws SubscriptionException {
        this.acquireReadLock();
        try {
            this.checkBeforeCreateConsumerInternal(createConsumerReq);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeCreateConsumerInternal(TCreateConsumerReq createConsumerReq) throws SubscriptionException {
        if (!this.isConsumerGroupExisted(createConsumerReq.getConsumerGroupId()) || !this.isConsumerExisted(createConsumerReq.getConsumerGroupId(), createConsumerReq.getConsumerId())) {
            return;
        }
        String exceptionMessage = String.format("Failed to create pipe consumer %s in consumer group %s, the consumer with the same name has been created", createConsumerReq.getConsumerId(), createConsumerReq.getConsumerGroupId());
        LOGGER.warn(exceptionMessage);
        throw new SubscriptionException(exceptionMessage);
    }

    public void validateBeforeDroppingConsumer(TCloseConsumerReq dropConsumerReq) throws SubscriptionException {
        this.acquireReadLock();
        try {
            this.checkBeforeDropConsumerInternal(dropConsumerReq);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeDropConsumerInternal(TCloseConsumerReq dropConsumerReq) throws SubscriptionException {
        if (this.isConsumerExisted(dropConsumerReq.getConsumerGroupId(), dropConsumerReq.getConsumerId())) {
            return;
        }
        String exceptionMessage = String.format("Failed to drop pipe consumer %s in consumer group %s, the consumer does not exist", dropConsumerReq.getConsumerId(), dropConsumerReq.getConsumerGroupId());
        LOGGER.warn(exceptionMessage);
        throw new SubscriptionException(exceptionMessage);
    }

    public void validateBeforeAlterConsumerGroup(ConsumerGroupMeta consumerGroupMeta) throws SubscriptionException {
        this.acquireReadLock();
        try {
            this.checkBeforeAlterConsumerGroupInternal(consumerGroupMeta);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void checkBeforeAlterConsumerGroupInternal(ConsumerGroupMeta consumerGroupMeta) throws SubscriptionException {
        if (this.isConsumerGroupExisted(consumerGroupMeta.getConsumerGroupId())) {
            return;
        }
        String exceptionMessage = String.format("Failed to alter consumer group because the consumer group %s does not exist", consumerGroupMeta.getConsumerGroupId());
        LOGGER.warn(exceptionMessage);
        throw new SubscriptionException(exceptionMessage);
    }

    public boolean isConsumerGroupExisted(String consumerGroupName) {
        this.acquireReadLock();
        try {
            boolean bl = this.consumerGroupMetaKeeper.containsConsumerGroupMeta(consumerGroupName);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsumerExisted(String consumerGroupName, String consumerId) {
        this.acquireReadLock();
        try {
            ConsumerGroupMeta consumerGroupMeta = this.consumerGroupMetaKeeper.getConsumerGroupMeta(consumerGroupName);
            boolean bl = consumerGroupMeta != null && consumerGroupMeta.containsConsumer(consumerId);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public ConsumerGroupMeta getConsumerGroupMeta(String consumerGroupName) {
        this.acquireReadLock();
        try {
            ConsumerGroupMeta consumerGroupMeta = this.consumerGroupMetaKeeper.getConsumerGroupMeta(consumerGroupName);
            return consumerGroupMeta;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public ConsumerGroupMeta deepCopyConsumerGroupMeta(String consumerGroupName) {
        this.acquireReadLock();
        try {
            ConsumerGroupMeta consumerGroupMeta = this.consumerGroupMetaKeeper.containsConsumerGroupMeta(consumerGroupName) ? this.consumerGroupMetaKeeper.getConsumerGroupMeta(consumerGroupName).deepCopy() : null;
            return consumerGroupMeta;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTopicSubscribedByConsumerGroup(String topicName, String consumerGroupId) {
        this.acquireReadLock();
        try {
            boolean bl = this.consumerGroupMetaKeeper.isTopicSubscribedByConsumerGroup(topicName, consumerGroupId);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus alterConsumerGroup(AlterConsumerGroupPlan plan) {
        this.acquireWriteLock();
        try {
            ConsumerGroupMeta consumerGroupMeta = plan.getConsumerGroupMeta();
            if (Objects.nonNull(consumerGroupMeta)) {
                String consumerGroupId = consumerGroupMeta.getConsumerGroupId();
                this.consumerGroupMetaKeeper.removeConsumerGroupMeta(consumerGroupId);
                if (!consumerGroupMeta.isEmpty()) {
                    this.consumerGroupMetaKeeper.addConsumerGroupMeta(consumerGroupId, consumerGroupMeta);
                }
            }
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public TSStatus handleConsumerGroupMetaChanges(ConsumerGroupHandleMetaChangePlan plan) {
        this.acquireWriteLock();
        try {
            LOGGER.info("Handling consumer group meta changes ...");
            this.consumerGroupMetaKeeper.clear();
            plan.getConsumerGroupMetaList().forEach(consumerGroupMeta -> {
                this.consumerGroupMetaKeeper.addConsumerGroupMeta(consumerGroupMeta.getConsumerGroupId(), consumerGroupMeta);
                LOGGER.info("Recording consumer group meta: {}", consumerGroupMeta);
            });
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void validateBeforeSubscribe(TSubscribeReq subscribeReq) throws SubscriptionException {
        this.acquireReadLock();
        try {
            this.checkBeforeSubscribeInternal(subscribeReq);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeSubscribeInternal(TSubscribeReq subscribeReq) throws SubscriptionException {
        if (!this.isConsumerExisted(subscribeReq.getConsumerGroupId(), subscribeReq.getConsumerId())) {
            String exceptionMessage = String.format("Failed to subscribe because the consumer %s in consumer group %s does not exist", subscribeReq.getConsumerId(), subscribeReq.getConsumerGroupId());
            LOGGER.warn(exceptionMessage);
            throw new SubscriptionException(exceptionMessage);
        }
        for (String topic : subscribeReq.getTopicNames()) {
            if (this.isTopicExisted(topic)) continue;
            String exceptionMessage = String.format("Failed to subscribe because the topic %s does not exist", topic);
            LOGGER.warn(exceptionMessage);
            throw new SubscriptionException(exceptionMessage);
        }
    }

    public void validateBeforeUnsubscribe(TUnsubscribeReq unsubscribeReq) throws SubscriptionException {
        this.acquireReadLock();
        try {
            this.checkBeforeUnsubscribeInternal(unsubscribeReq);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeUnsubscribeInternal(TUnsubscribeReq unsubscribeReq) throws SubscriptionException {
        if (!this.isConsumerExisted(unsubscribeReq.getConsumerGroupId(), unsubscribeReq.getConsumerId())) {
            String exceptionMessage = String.format("Failed to unsubscribe because the consumer %s in consumer group %s does not exist", unsubscribeReq.getConsumerId(), unsubscribeReq.getConsumerGroupId());
            LOGGER.warn(exceptionMessage);
            throw new SubscriptionException(exceptionMessage);
        }
        for (String topic : unsubscribeReq.getTopicNames()) {
            if (this.isTopicExisted(topic)) continue;
            String exceptionMessage = String.format("Failed to unsubscribe because the topic %s does not exist", topic);
            LOGGER.warn(exceptionMessage);
            throw new SubscriptionException(exceptionMessage);
        }
    }

    public DataSet showSubscriptions() {
        this.acquireReadLock();
        try {
            SubscriptionTableResp subscriptionTableResp = new SubscriptionTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), this.getAllSubscriptionMeta(), this.getAllConsumerGroupMeta());
            return subscriptionTableResp;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private List<SubscriptionMeta> getAllSubscriptionMeta() {
        ArrayList<SubscriptionMeta> allSubscriptions = new ArrayList<SubscriptionMeta>();
        for (TopicMeta topicMeta : this.topicMetaKeeper.getAllTopicMeta()) {
            for (String consumerGroupId : this.consumerGroupMetaKeeper.getSubscribedConsumerGroupIds(topicMeta.getTopicName())) {
                Set subscribedConsumerIDs = this.consumerGroupMetaKeeper.getConsumersSubscribingTopic(consumerGroupId, topicMeta.getTopicName());
                if (subscribedConsumerIDs.isEmpty()) continue;
                allSubscriptions.add(new SubscriptionMeta(topicMeta.getTopicName(), consumerGroupId, subscribedConsumerIDs));
            }
        }
        return allSubscriptions;
    }

    public List<ConsumerGroupMeta> getAllConsumerGroupMeta() {
        return StreamSupport.stream(this.consumerGroupMetaKeeper.getAllConsumerGroupMeta().spliterator(), false).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        this.acquireReadLock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
            if (snapshotFile.exists() && snapshotFile.isFile()) {
                LOGGER.error("Failed to take subscription snapshot, because snapshot file {} is already exist.", (Object)snapshotFile.getAbsolutePath());
                boolean bl = false;
                return bl;
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
                this.topicMetaKeeper.processTakeSnapshot(fileOutputStream);
                this.consumerGroupMetaKeeper.processTakeSnapshot(fileOutputStream);
                fileOutputStream.getFD().sync();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.acquireWriteLock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
            if (!snapshotFile.exists() || !snapshotFile.isFile()) {
                LOGGER.error("Failed to load subscription snapshot, snapshot file {} is not exist.", (Object)snapshotFile.getAbsolutePath());
                return;
            }
            try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
                this.topicMetaKeeper.processLoadSnapshot(fileInputStream);
                this.consumerGroupMetaKeeper.processLoadSnapshot(fileInputStream);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private class SubscriptionInfoVersion {
        private final AtomicLong latestVersion = new AtomicLong(0L);
        private long lastSyncedVersion = 0L;
        private boolean isLastSyncedPipeTaskInfoEmpty = false;

        public void increaseLatestVersion() {
            this.latestVersion.incrementAndGet();
        }

        public void updateLastSyncedVersion() {
            this.lastSyncedVersion = this.latestVersion.get();
            this.isLastSyncedPipeTaskInfoEmpty = SubscriptionInfo.this.topicMetaKeeper.isEmpty() && SubscriptionInfo.this.consumerGroupMetaKeeper.isEmpty();
        }

        public boolean canSkipNextSync() {
            return this.isLastSyncedPipeTaskInfoEmpty && SubscriptionInfo.this.topicMetaKeeper.isEmpty() && SubscriptionInfo.this.consumerGroupMetaKeeper.isEmpty() && this.lastSyncedVersion == this.latestVersion.get();
        }
    }
}

