/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler;

import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;

public abstract class PipeTransferTrackableHandler
implements AsyncMethodCallback<TPipeTransferResp>,
AutoCloseable {
    protected final IoTDBDataRegionAsyncConnector connector;

    public PipeTransferTrackableHandler(IoTDBDataRegionAsyncConnector connector) {
        this.connector = connector;
    }

    public void onComplete(TPipeTransferResp response) {
        if (this.connector.isClosed()) {
            this.clearEventsReferenceCount();
            this.connector.eliminateHandler(this);
            return;
        }
        if (this.onCompleteInternal(response)) {
            this.connector.eliminateHandler(this);
        }
    }

    public void onError(Exception exception) {
        if (this.connector.isClosed()) {
            this.clearEventsReferenceCount();
            this.connector.eliminateHandler(this);
            return;
        }
        this.onErrorInternal(exception);
        this.connector.eliminateHandler(this);
    }

    protected boolean tryTransfer(AsyncPipeDataTransferServiceClient client, TPipeTransferReq req) throws TException {
        this.connector.trackHandler(this);
        if (this.connector.isClosed()) {
            this.clearEventsReferenceCount();
            this.connector.eliminateHandler(this);
            return false;
        }
        this.doTransfer(client, req);
        return true;
    }

    protected abstract boolean onCompleteInternal(TPipeTransferResp var1);

    protected abstract void onErrorInternal(Exception var1);

    protected abstract void doTransfer(AsyncPipeDataTransferServiceClient var1, TPipeTransferReq var2) throws TException;

    public abstract void clearEventsReferenceCount();

    @Override
    public void close() {
    }
}

