/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.schema.ttl.TTLCache;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;

public class DataNodeTTLCache {
    private final TTLCache ttlCache;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private DataNodeTTLCache() {
        this.ttlCache = new TTLCache();
    }

    public static DataNodeTTLCache getInstance() {
        return DataNodeTTLCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTTL(String path, long ttl) throws IllegalPathException {
        this.lock.writeLock().lock();
        try {
            this.ttlCache.setTTL(PathUtils.splitPathToDetachedNodes((String)path), ttl);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTTL(String[] path, long ttl) {
        this.lock.writeLock().lock();
        try {
            this.ttlCache.setTTL(path, ttl);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void unsetTTL(String[] path) {
        this.lock.writeLock().lock();
        try {
            this.ttlCache.unsetTTL(path);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public long getTTL(IDeviceID deviceID) {
        try {
            return this.getTTL(((PlainDeviceID)deviceID).toStringID());
        }
        catch (IllegalPathException e) {
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTTL(String path) throws IllegalPathException {
        this.lock.readLock().lock();
        try {
            long ttl = this.ttlCache.getClosestTTL(PathUtils.splitPathToDetachedNodes((String)path));
            long l = ttl == Long.MAX_VALUE ? ttl : CommonDateTimeUtils.convertMilliTimeWithPrecision((long)ttl, (String)CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTTL(String[] path) {
        this.lock.readLock().lock();
        try {
            long ttl = this.ttlCache.getClosestTTL(path);
            long l = ttl == Long.MAX_VALUE ? ttl : CommonDateTimeUtils.convertMilliTimeWithPrecision((long)ttl, (String)CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTTLInMS(String[] path) {
        this.lock.readLock().lock();
        try {
            long l = this.ttlCache.getClosestTTL(path);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNodeTTLInMS(String path) throws IllegalPathException {
        this.lock.readLock().lock();
        try {
            long l = this.ttlCache.getLastNodeTTL(PathUtils.splitPathToDetachedNodes((String)path));
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clearAllTTL() {
        this.lock.writeLock().lock();
        try {
            this.ttlCache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static class DataNodeTTLCacheHolder {
        private static final DataNodeTTLCache INSTANCE = new DataNodeTTLCache();

        private DataNodeTTLCacheHolder() {
        }
    }
}

