/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TimeSeriesSchemaScanNode
extends SchemaQueryScanNode {
    private final boolean orderByHeat;
    private final SchemaFilter schemaFilter;
    private final Map<Integer, Template> templateMap;

    public TimeSeriesSchemaScanNode(PlanNodeId id, PartialPath partialPath, SchemaFilter schemaFilter, long limit, long offset, boolean orderByHeat, boolean isPrefixPath, @NotNull Map<Integer, Template> templateMap, @NotNull PathPatternTree scope) {
        super(id, partialPath, limit, offset, isPrefixPath, scope);
        this.schemaFilter = schemaFilter;
        this.orderByHeat = orderByHeat;
        this.templateMap = templateMap;
    }

    public SchemaFilter getSchemaFilter() {
        return this.schemaFilter;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TIME_SERIES_SCHEMA_SCAN.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (ByteBuffer)byteBuffer);
        this.scope.serialize(byteBuffer);
        SchemaFilter.serialize((SchemaFilter)this.schemaFilter, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.limit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.offset, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.orderByHeat, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (ByteBuffer)byteBuffer);
        for (Template template : this.templateMap.values()) {
            template.serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TIME_SERIES_SCHEMA_SCAN.serialize(stream);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (OutputStream)stream);
        this.scope.serialize(stream);
        SchemaFilter.serialize((SchemaFilter)this.schemaFilter, (DataOutputStream)stream);
        ReadWriteIOUtils.write((long)this.limit, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.offset, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.orderByHeat, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (OutputStream)stream);
        for (Template template : this.templateMap.values()) {
            template.serialize(stream);
        }
    }

    public static TimeSeriesSchemaScanNode deserialize(ByteBuffer byteBuffer) {
        PartialPath path;
        String fullPath = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        try {
            path = new PartialPath(fullPath);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize TimeSeriesSchemaScanNode", e);
        }
        PathPatternTree scope = PathPatternTree.deserialize((ByteBuffer)byteBuffer);
        SchemaFilter schemaFilter = SchemaFilter.deserialize((ByteBuffer)byteBuffer);
        long limit = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long offset = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        boolean oderByHeat = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean isPrefixPath = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        for (int i = 0; i < templateNum; ++i) {
            Template template = new Template();
            template.deserialize(byteBuffer);
            templateMap.put(template.getId(), template);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new TimeSeriesSchemaScanNode(planNodeId, path, schemaFilter, limit, offset, oderByHeat, isPrefixPath, templateMap, scope);
    }

    public boolean isOrderByHeat() {
        return this.orderByHeat;
    }

    public Map<Integer, Template> getTemplateMap() {
        return this.templateMap;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.TIME_SERIES_SCHEMA_SCAN;
    }

    @Override
    public PlanNode clone() {
        return new TimeSeriesSchemaScanNode(this.getPlanNodeId(), this.path, this.schemaFilter, this.limit, this.offset, this.orderByHeat, this.isPrefixPath, this.templateMap, this.scope);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ColumnHeaderConstant.showTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeSeriesSchemaScanNode that = (TimeSeriesSchemaScanNode)o;
        return this.orderByHeat == that.orderByHeat && Objects.equals(this.schemaFilter, that.schemaFilter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.schemaFilter, this.orderByHeat);
    }

    @Override
    public String toString() {
        return String.format("TimeSeriesSchemaScanNode-%s:[DataRegion: %s]", this.getPlanNodeId(), this.getRegionReplicaSet());
    }
}

