/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi;

import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TypeUtils;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;

public abstract class UDFQueryTransformer
extends Transformer {
    protected final UDTFExecutor executor;
    protected TSDataType tsDataType;
    protected boolean terminated;

    protected UDFQueryTransformer(UDTFExecutor executor) {
        this.executor = executor;
        this.tsDataType = UDFDataTypeTransformer.transformToTsDataType((Type)executor.getConfigurations().getOutputDataType());
        this.terminated = false;
    }

    protected final boolean terminate() {
        if (this.terminated) {
            return false;
        }
        TimeColumnBuilder timeColumnBuilder = new TimeColumnBuilder(null, 1);
        ColumnBuilder valueColumnBuilder = TypeUtils.initColumnBuilder(this.tsDataType, 1);
        this.executor.terminate(timeColumnBuilder, valueColumnBuilder);
        this.terminated = true;
        return true;
    }

    @Override
    public final TSDataType[] getDataTypes() {
        return new TSDataType[]{this.tsDataType};
    }
}

