/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.server.GrpcServices;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GrpcConfigKeys {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcConfigKeys.class);
    public static final String PREFIX = "raft.grpc";
    public static final String MESSAGE_SIZE_MAX_KEY = "raft.grpc.message.size.max";
    public static final SizeInBytes MESSAGE_SIZE_MAX_DEFAULT = SizeInBytes.valueOf((String)"64MB");
    public static final String FLOW_CONTROL_WINDOW_KEY = "raft.grpc.flow.control.window";
    public static final SizeInBytes FLOW_CONTROL_WINDOW_DEFAULT = SizeInBytes.valueOf((String)"1MB");

    public static Consumer<String> getDefaultLog() {
        return arg_0 -> ((Logger)LOG).info(arg_0);
    }

    public static SizeInBytes messageSizeMax(RaftProperties properties, Consumer<String> logger) {
        return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)MESSAGE_SIZE_MAX_KEY, (SizeInBytes)MESSAGE_SIZE_MAX_DEFAULT, logger, (BiConsumer[])new BiConsumer[0]);
    }

    public static void setMessageSizeMax(RaftProperties properties, SizeInBytes maxMessageSize) {
        ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)MESSAGE_SIZE_MAX_KEY, (SizeInBytes)maxMessageSize, (BiConsumer[])new BiConsumer[0]);
    }

    public static SizeInBytes flowControlWindow(RaftProperties properties, Consumer<String> logger) {
        return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)FLOW_CONTROL_WINDOW_KEY, (SizeInBytes)FLOW_CONTROL_WINDOW_DEFAULT, logger, (BiConsumer[])new BiConsumer[0]);
    }

    public static void setFlowControlWindow(RaftProperties properties, SizeInBytes flowControlWindowSize) {
        ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)FLOW_CONTROL_WINDOW_KEY, (SizeInBytes)flowControlWindowSize, (BiConsumer[])new BiConsumer[0]);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(GrpcConfigKeys.class);
    }

    public static interface Server {
        public static final String PREFIX = "raft.grpc.server";
        public static final String HOST_KEY = "raft.grpc.server.host";
        public static final String HOST_DEFAULT = null;
        public static final String PORT_KEY = "raft.grpc.server.port";
        public static final int PORT_DEFAULT = 0;
        public static final String ASYNC_REQUEST_THREAD_POOL_CACHED_KEY = "raft.grpc.server.async.request.thread.pool.cached";
        public static final boolean ASYNC_REQUEST_THREAD_POOL_CACHED_DEFAULT = true;
        public static final String ASYNC_REQUEST_THREAD_POOL_SIZE_KEY = "raft.grpc.server.async.request.thread.pool.size";
        public static final int ASYNC_REQUEST_THREAD_POOL_SIZE_DEFAULT = 32;
        public static final String LEADER_OUTSTANDING_APPENDS_MAX_KEY = "raft.grpc.server.leader.outstanding.appends.max";
        public static final int LEADER_OUTSTANDING_APPENDS_MAX_DEFAULT = 8;
        public static final String INSTALL_SNAPSHOT_REQUEST_ELEMENT_LIMIT_KEY = "raft.grpc.server.install_snapshot.request.element-limit";
        public static final int INSTALL_SNAPSHOT_REQUEST_ELEMENT_LIMIT_DEFAULT = 8;
        public static final String INSTALL_SNAPSHOT_REQUEST_TIMEOUT_KEY = "raft.grpc.server.install_snapshot.request.timeout";
        public static final TimeDuration INSTALL_SNAPSHOT_REQUEST_TIMEOUT_DEFAULT = RaftServerConfigKeys.Rpc.REQUEST_TIMEOUT_DEFAULT;
        public static final String HEARTBEAT_CHANNEL_KEY = "raft.grpc.server.heartbeat.channel";
        public static final boolean HEARTBEAT_CHANNEL_DEFAULT = true;
        public static final String LOG_MESSAGE_BATCH_DURATION_KEY = "raft.grpc.server.log-message.batch.duration";
        public static final TimeDuration LOG_MESSAGE_BATCH_DURATION_DEFAULT = TimeDuration.valueOf((long)5L, (TimeUnit)TimeUnit.SECONDS);
        public static final String SERVICES_CUSTOMIZER_PARAMETER = "raft.grpc.server.services.customizer";
        public static final Class<GrpcServices.Customizer> SERVICES_CUSTOMIZER_CLASS = GrpcServices.Customizer.class;
        public static final String TLS_CONF_PARAMETER = "raft.grpc.server.tls.conf";
        public static final Class<GrpcTlsConfig> TLS_CONF_CLASS = TLS.CONF_CLASS;

        public static String host(RaftProperties properties) {
            return Server.host(properties, GrpcConfigKeys.getDefaultLog());
        }

        public static String host(RaftProperties properties, Consumer<String> logger) {
            return (String)ConfUtils.get((arg_0, arg_1) -> ((RaftProperties)properties).get(arg_0, arg_1), (String)HOST_KEY, (Object)HOST_DEFAULT, logger, (BiConsumer[])new BiConsumer[0]);
        }

        public static void setHost(RaftProperties properties, String host) {
            ConfUtils.set((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)HOST_KEY, (Object)host, (BiConsumer[])new BiConsumer[0]);
        }

        public static int port(RaftProperties properties) {
            return Server.port(properties, GrpcConfigKeys.getDefaultLog());
        }

        public static int port(RaftProperties properties, Consumer<String> logger) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)PORT_KEY, (int)0, logger, (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0), ConfUtils.requireMax((int)65536)});
        }

        public static void setPort(RaftProperties properties, int port) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)PORT_KEY, (int)port, (BiConsumer[])new BiConsumer[0]);
        }

        public static boolean asyncRequestThreadPoolCached(RaftProperties properties) {
            return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)ASYNC_REQUEST_THREAD_POOL_CACHED_KEY, (boolean)true, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setAsyncRequestThreadPoolCached(RaftProperties properties, boolean useCached) {
            ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)ASYNC_REQUEST_THREAD_POOL_CACHED_KEY, (boolean)useCached, (BiConsumer[])new BiConsumer[0]);
        }

        public static int asyncRequestThreadPoolSize(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)ASYNC_REQUEST_THREAD_POOL_SIZE_KEY, (int)32, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0), ConfUtils.requireMax((int)65536)});
        }

        public static void setAsyncRequestThreadPoolSize(RaftProperties properties, int port) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)ASYNC_REQUEST_THREAD_POOL_SIZE_KEY, (int)port, (BiConsumer[])new BiConsumer[0]);
        }

        public static int leaderOutstandingAppendsMax(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)LEADER_OUTSTANDING_APPENDS_MAX_KEY, (int)8, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
        }

        public static void setLeaderOutstandingAppendsMax(RaftProperties properties, int maxAppend) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)LEADER_OUTSTANDING_APPENDS_MAX_KEY, (int)maxAppend, (BiConsumer[])new BiConsumer[0]);
        }

        public static int installSnapshotRequestElementLimit(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)INSTALL_SNAPSHOT_REQUEST_ELEMENT_LIMIT_KEY, (int)8, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
        }

        public static void setInstallSnapshotRequestElementLimit(RaftProperties properties, int elementLimit) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)INSTALL_SNAPSHOT_REQUEST_ELEMENT_LIMIT_KEY, (int)elementLimit, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration installSnapshotRequestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(INSTALL_SNAPSHOT_REQUEST_TIMEOUT_DEFAULT.getUnit()), (String)INSTALL_SNAPSHOT_REQUEST_TIMEOUT_KEY, (TimeDuration)INSTALL_SNAPSHOT_REQUEST_TIMEOUT_DEFAULT, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setInstallSnapshotRequestTimeout(RaftProperties properties, TimeDuration installSnapshotRequestTimeout) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)INSTALL_SNAPSHOT_REQUEST_TIMEOUT_KEY, (TimeDuration)installSnapshotRequestTimeout, (BiConsumer[])new BiConsumer[0]);
        }

        public static boolean heartbeatChannel(RaftProperties properties) {
            return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)HEARTBEAT_CHANNEL_KEY, (boolean)true, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setHeartbeatChannel(RaftProperties properties, boolean useSeparate) {
            ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)HEARTBEAT_CHANNEL_KEY, (boolean)useSeparate, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration logMessageBatchDuration(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(LOG_MESSAGE_BATCH_DURATION_DEFAULT.getUnit()), (String)LOG_MESSAGE_BATCH_DURATION_KEY, (TimeDuration)LOG_MESSAGE_BATCH_DURATION_DEFAULT, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setLogMessageBatchDuration(RaftProperties properties, TimeDuration logMessageBatchDuration) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)LOG_MESSAGE_BATCH_DURATION_KEY, (TimeDuration)logMessageBatchDuration, (BiConsumer[])new BiConsumer[0]);
        }

        public static GrpcServices.Customizer servicesCustomizer(Parameters parameters) {
            return parameters == null ? null : (GrpcServices.Customizer)parameters.get(SERVICES_CUSTOMIZER_PARAMETER, SERVICES_CUSTOMIZER_CLASS);
        }

        public static void setServicesCustomizer(Parameters parameters, GrpcServices.Customizer customizer) {
            parameters.put(SERVICES_CUSTOMIZER_PARAMETER, (Object)customizer, SERVICES_CUSTOMIZER_CLASS);
        }

        public static GrpcTlsConfig tlsConf(Parameters parameters) {
            return parameters != null ? (GrpcTlsConfig)((Object)parameters.get(TLS_CONF_PARAMETER, TLS_CONF_CLASS)) : null;
        }

        public static void setTlsConf(Parameters parameters, GrpcTlsConfig conf) {
            parameters.put(TLS_CONF_PARAMETER, (Object)conf, TLS_CONF_CLASS);
        }
    }

    public static interface Client {
        public static final String PREFIX = "raft.grpc.client";
        public static final String HOST_KEY = "raft.grpc.client.host";
        public static final String HOST_DEFAULT = null;
        public static final String PORT_KEY = "raft.grpc.client.port";
        public static final int PORT_DEFAULT = -1;
        public static final String TLS_CONF_PARAMETER = "raft.grpc.client.tls.conf";
        public static final Class<GrpcTlsConfig> TLS_CONF_CLASS = TLS.CONF_CLASS;

        public static String host(RaftProperties properties) {
            String fallbackServerHost = Server.host(properties, null);
            return (String)ConfUtils.get((arg_0, arg_1) -> ((RaftProperties)properties).get(arg_0, arg_1), (String)HOST_KEY, (Object)HOST_DEFAULT, (String)"raft.grpc.server.host", (Object)fallbackServerHost, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setHost(RaftProperties properties, String host) {
            ConfUtils.set((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)HOST_KEY, (Object)host, (BiConsumer[])new BiConsumer[0]);
        }

        public static int port(RaftProperties properties) {
            int fallbackServerPort = Server.port(properties, null);
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)PORT_KEY, (int)-1, (String)"raft.grpc.server.port", (int)fallbackServerPort, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)-1), ConfUtils.requireMax((int)65536)});
        }

        public static void setPort(RaftProperties properties, int port) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)PORT_KEY, (int)port, (BiConsumer[])new BiConsumer[0]);
        }

        public static GrpcTlsConfig tlsConf(Parameters parameters) {
            return parameters != null ? (GrpcTlsConfig)((Object)parameters.get(TLS_CONF_PARAMETER, TLS_CONF_CLASS)) : null;
        }

        public static void setTlsConf(Parameters parameters, GrpcTlsConfig conf) {
            parameters.put(TLS_CONF_PARAMETER, (Object)conf, TLS_CONF_CLASS);
        }
    }

    public static interface Admin {
        public static final String PREFIX = "raft.grpc.admin";
        public static final String HOST_KEY = "raft.grpc.admin.host";
        public static final String HOST_DEFAULT = null;
        public static final String PORT_KEY = "raft.grpc.admin.port";
        public static final int PORT_DEFAULT = -1;
        public static final String TLS_CONF_PARAMETER = "raft.grpc.admin.tls.conf";
        public static final Class<GrpcTlsConfig> TLS_CONF_CLASS = TLS.CONF_CLASS;

        public static String host(RaftProperties properties) {
            String fallbackServerHost = Server.host(properties, null);
            return (String)ConfUtils.get((arg_0, arg_1) -> ((RaftProperties)properties).get(arg_0, arg_1), (String)HOST_KEY, (Object)HOST_DEFAULT, (String)"raft.grpc.server.host", (Object)fallbackServerHost, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setHost(RaftProperties properties, String host) {
            ConfUtils.set((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)HOST_KEY, (Object)host, (BiConsumer[])new BiConsumer[0]);
        }

        public static int port(RaftProperties properties) {
            int fallbackServerPort = Server.port(properties, null);
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)PORT_KEY, (int)-1, (String)"raft.grpc.server.port", (int)fallbackServerPort, GrpcConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)-1), ConfUtils.requireMax((int)65536)});
        }

        public static void setPort(RaftProperties properties, int port) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)PORT_KEY, (int)port, (BiConsumer[])new BiConsumer[0]);
        }

        public static GrpcTlsConfig tlsConf(Parameters parameters) {
            return parameters != null ? (GrpcTlsConfig)((Object)parameters.get(TLS_CONF_PARAMETER, TLS_CONF_CLASS)) : null;
        }

        public static void setTlsConf(Parameters parameters, GrpcTlsConfig conf) {
            parameters.put(TLS_CONF_PARAMETER, (Object)conf, TLS_CONF_CLASS);
        }
    }

    public static interface TLS {
        public static final String PREFIX = "raft.grpc.tls";
        public static final String CONF_PARAMETER = "raft.grpc.tls.conf";
        public static final Class<GrpcTlsConfig> CONF_CLASS = GrpcTlsConfig.class;

        @Deprecated
        public static void setEnabled(RaftProperties properties, boolean enabled) {
            LOG.warn("This method has no effect. Use setConf(Parameters, GrpcTlsConfig) instead.");
        }

        @Deprecated
        public static void setMutualAuthnEnabled(RaftProperties properties, boolean mutualAuthnEnabled) {
            LOG.warn("This method has no effect. Use setConf(Parameters, GrpcTlsConfig) instead.");
        }

        @Deprecated
        public static void setPrivateKeyFileName(RaftProperties properties, String privateKeyFileName) {
            LOG.warn("This method has no effect. Use setConf(Parameters, GrpcTlsConfig) instead.");
        }

        @Deprecated
        public static void setCertChainFileName(RaftProperties properties, String certChainFileName) {
            LOG.warn("This method has no effect. Use setConf(Parameters, GrpcTlsConfig) instead.");
        }

        @Deprecated
        public static void setTrustStore(RaftProperties properties, String trustStore) {
            LOG.warn("This method has no effect. Use setConf(Parameters, GrpcTlsConfig) instead.");
        }

        public static GrpcTlsConfig conf(Parameters parameters) {
            return parameters != null ? (GrpcTlsConfig)((Object)parameters.get(CONF_PARAMETER, CONF_CLASS)) : null;
        }

        public static void setConf(Parameters parameters, GrpcTlsConfig conf) {
            parameters.put(CONF_PARAMETER, (Object)conf, GrpcTlsConfig.class);
        }
    }
}

