/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.util.sorter;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.iotdb.db.pipe.sink.util.sorter.PipeTabletEventSorter;
import org.apache.tsfile.write.record.Tablet;

public class PipeTreeModelTabletEventSorter
extends PipeTabletEventSorter {
    public PipeTreeModelTabletEventSorter(Tablet tablet) {
        super(tablet);
        this.deDuplicatedSize = tablet == null ? 0 : tablet.getRowSize();
    }

    public void deduplicateAndSortTimestampsIfNecessary() {
        int i;
        if (this.tablet == null || this.tablet.getRowSize() == 0) {
            return;
        }
        long[] timestamps = this.tablet.getTimestamps();
        int size = this.tablet.getRowSize();
        for (i = 1; i < size; ++i) {
            long currentTimestamp = timestamps[i];
            long previousTimestamp = timestamps[i - 1];
            if (currentTimestamp < previousTimestamp) {
                this.isSorted = false;
                break;
            }
            if (currentTimestamp != previousTimestamp) continue;
            this.isDeDuplicated = false;
        }
        if (this.isSorted && this.isDeDuplicated) {
            return;
        }
        this.index = new Integer[this.tablet.getRowSize()];
        this.deDuplicatedIndex = new int[this.tablet.getRowSize()];
        size = this.tablet.getRowSize();
        for (i = 0; i < size; ++i) {
            this.index[i] = i;
        }
        if (!this.isSorted) {
            this.sortTimestamps();
            this.deduplicateTimestamps();
            this.isDeDuplicated = true;
        }
        if (!this.isDeDuplicated) {
            this.deduplicateTimestamps();
        }
        this.sortAndMayDeduplicateValuesAndBitMaps();
    }

    private void sortTimestamps() {
        Arrays.sort(this.index, Comparator.comparingLong(arg_0 -> ((Tablet)this.tablet).getTimestamp(arg_0)));
        Arrays.sort(this.tablet.getTimestamps(), 0, this.tablet.getRowSize());
    }

    private void deduplicateTimestamps() {
        this.deDuplicatedSize = 0;
        long[] timestamps = this.tablet.getTimestamps();
        int size = this.tablet.getRowSize();
        for (int i = 1; i < size; ++i) {
            if (timestamps[i] == timestamps[i - 1]) continue;
            this.deDuplicatedIndex[this.deDuplicatedSize] = i - 1;
            timestamps[this.deDuplicatedSize] = timestamps[i - 1];
            ++this.deDuplicatedSize;
        }
        this.deDuplicatedIndex[this.deDuplicatedSize] = this.tablet.getRowSize() - 1;
        timestamps[this.deDuplicatedSize] = timestamps[this.tablet.getRowSize() - 1];
        this.tablet.setRowSize(++this.deDuplicatedSize);
    }
}

