/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.RamUsageEstimator;

public class CountAllAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(CountAllAccumulator.class);
    private long countState = 0L;

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new CountAllAccumulator();
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of COUNT(*) should be one column");
        int count = mask.getSelectedPositionCount();
        this.countState += (long)count;
    }

    @Override
    public void removeInput(Column[] arguments) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of COUNT(*) should be one column");
        int count = arguments[0].getPositionCount();
        this.countState -= (long)count;
    }

    @Override
    public void addIntermediate(Column argument) {
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            this.countState += argument.getLong(i);
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countState);
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countState);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        throw new UnsupportedOperationException("CountAllAccumulator does not support statistics.");
    }

    @Override
    public void reset() {
        this.countState = 0L;
    }

    @Override
    public boolean removable() {
        return true;
    }
}

