/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanType;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.DeviceAttributeCacheUpdater;

public class TableNodeLocationAddNode
extends PlanNode
implements ISchemaRegionPlan {
    private final TDataNodeLocation location;
    public static final TableNodeLocationAddNode MOCK_INSTANCE = new TableNodeLocationAddNode(new PlanNodeId(""), null);

    public TableNodeLocationAddNode(PlanNodeId id, TDataNodeLocation location) {
        super(id);
        this.location = location;
    }

    public TDataNodeLocation getLocation() {
        return this.location;
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        return new TableNodeLocationAddNode(this.id, this.location);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableNodeLocationAdd(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        this.getType().serialize(byteBuffer);
        DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(this.location, byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        this.getType().serialize(stream);
        DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(this.location, stream);
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        TDataNodeLocation location = DeviceAttributeCacheUpdater.deserializeNodeLocationForAttributeUpdate(buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new TableNodeLocationAddNode(planNodeId, location);
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.TABLE_DEVICE_LOCATION_ADD;
    }

    @Override
    public SchemaRegionPlanType getPlanType() {
        return SchemaRegionPlanType.ADD_NODE_LOCATION;
    }

    @Override
    public <R, C> R accept(SchemaRegionPlanVisitor<R, C> visitor, C context) {
        return visitor.visitAddNodeLocation(this, context);
    }
}

