/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.flush;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedThreadPoolExecutor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.CachedMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.flush.PBTreeFlushExecutor;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.lock.LockManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.IReleaseFlushStrategy;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.IMemoryManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);
    private int BATCH_FLUSH_SUBTREE = 50;
    private int FLUSH_WORKER_NUM = 10;
    private final Map<Integer, CachedMTreeStore> regionToStore;
    private final Set<Integer> flushingRegionSet;
    private final ExecutorService workerPool;
    private final IReleaseFlushStrategy releaseFlushStrategy;

    public Scheduler(Map<Integer, CachedMTreeStore> regionToStore, Set<Integer> flushingRegionSet, IReleaseFlushStrategy releaseFlushStrategy) {
        this.regionToStore = regionToStore;
        this.workerPool = IoTDBThreadPoolFactory.newFixedThreadPool((int)this.FLUSH_WORKER_NUM, (String)ThreadName.PBTREE_WORKER_POOL.getName(), (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
        this.flushingRegionSet = flushingRegionSet;
        this.releaseFlushStrategy = releaseFlushStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFlush(CachedMTreeStore store, int regionId, AtomicInteger remainToFlush) {
        IMemoryManager memoryManager = store.getMemoryManager();
        ISchemaFile file = store.getSchemaFile();
        LockManager lockManager = store.getLockManager();
        long startTime = System.currentTimeMillis();
        AtomicLong flushNodeNum = new AtomicLong(0L);
        AtomicLong flushMemSize = new AtomicLong(0L);
        try {
            PBTreeFlushExecutor flushExecutor = remainToFlush == null ? new PBTreeFlushExecutor(memoryManager, file, lockManager) : new PBTreeFlushExecutor(remainToFlush, memoryManager, file, lockManager);
            flushExecutor.flushVolatileNodes(flushNodeNum, flushMemSize);
        }
        catch (MetadataException e) {
            LOGGER.warn("Error occurred during MTree flush, current SchemaRegionId is {} because {}", new Object[]{regionId, e.getMessage(), e});
        }
        finally {
            long time = System.currentTimeMillis() - startTime;
            if (time > 10000L) {
                LOGGER.info("It takes {}ms to flush MTree in SchemaRegion {}", (Object)time, (Object)regionId);
            } else {
                LOGGER.debug("It takes {}ms to flush MTree in SchemaRegion {}", (Object)time, (Object)regionId);
            }
            store.recordFlushMetrics(time, flushNodeNum.get(), flushMemSize.get());
            this.flushingRegionSet.remove(regionId);
        }
    }

    private void executeRelease(CachedMTreeStore store, boolean force) {
        AtomicLong releaseNodeNum = new AtomicLong(0L);
        AtomicLong releaseMemorySize = new AtomicLong(0L);
        long startTime = System.currentTimeMillis();
        while ((force || this.releaseFlushStrategy.isExceedReleaseThreshold()) && !store.executeMemoryRelease(releaseNodeNum, releaseMemorySize)) {
        }
        store.recordReleaseMetrics(System.currentTimeMillis() - startTime, releaseNodeNum.get(), releaseMemorySize.get());
    }

    public synchronized CompletableFuture<Void> scheduleFlushAll() {
        ArrayList<Map.Entry<Integer, CachedMTreeStore>> flushEngineList = new ArrayList<Map.Entry<Integer, CachedMTreeStore>>();
        for (Map.Entry<Integer, CachedMTreeStore> entry2 : this.regionToStore.entrySet()) {
            if (this.flushingRegionSet.contains(entry2.getKey())) continue;
            this.flushingRegionSet.add(entry2.getKey());
            flushEngineList.add(entry2);
        }
        return CompletableFuture.allOf((CompletableFuture[])flushEngineList.stream().map(entry -> CompletableFuture.runAsync(() -> {
            int regionId = (Integer)entry.getKey();
            CachedMTreeStore store = (CachedMTreeStore)entry.getValue();
            if (store == null) {
                return;
            }
            LockManager lockManager = store.getLockManager();
            lockManager.globalReadLock();
            if (!this.regionToStore.containsKey(regionId)) {
                return;
            }
            try {
                this.executeFlush(store, regionId, null);
                this.executeRelease(store, false);
            }
            finally {
                lockManager.globalReadUnlock();
            }
        }, this.workerPool)).toArray(CompletableFuture[]::new));
    }

    public synchronized void scheduleRelease(boolean force) {
        CompletableFuture.allOf((CompletableFuture[])this.regionToStore.entrySet().stream().map(entry -> CompletableFuture.runAsync(() -> {
            int regionId = (Integer)entry.getKey();
            CachedMTreeStore store = (CachedMTreeStore)entry.getValue();
            if (store == null) {
                return;
            }
            LockManager lockManager = store.getLockManager();
            lockManager.globalReadLock(true);
            if (!this.regionToStore.containsKey(regionId)) {
                return;
            }
            try {
                this.executeRelease(store, force);
            }
            finally {
                lockManager.globalReadUnlock();
            }
        }, this.workerPool)).toArray(CompletableFuture[]::new)).join();
    }

    public synchronized void scheduleFlush(List<Integer> regionIds) {
        AtomicInteger remainToFlush = new AtomicInteger(this.BATCH_FLUSH_SUBTREE);
        for (int regionId : regionIds) {
            if (this.flushingRegionSet.contains(regionId)) continue;
            this.flushingRegionSet.add(regionId);
            this.workerPool.submit(() -> {
                CachedMTreeStore store = this.regionToStore.get(regionId);
                if (store == null) {
                    return;
                }
                LockManager lockManager = store.getLockManager();
                lockManager.globalReadLock();
                if (!this.regionToStore.containsKey(regionId)) {
                    return;
                }
                try {
                    this.executeFlush(store, regionId, remainToFlush);
                }
                finally {
                    lockManager.globalReadUnlock();
                }
            });
            if (remainToFlush.get() > 0) continue;
            break;
        }
    }

    public int getActiveWorkerNum() {
        return ((WrappedThreadPoolExecutor)this.workerPool).getActiveCount();
    }

    public void clear() {
        this.workerPool.shutdown();
    }

    public boolean isTerminated() {
        return this.workerPool.isTerminated();
    }
}

