/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tool;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.ITimeRange;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.Interval;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.ListTimeRangeImpl;
import org.apache.tsfile.file.metadata.IDeviceID;

public class UnseqSpaceStatistics {
    public long unsequenceFileNum = 0L;
    public long unsequenceFileSize = 0L;
    public long unsequenceChunkNum = 0L;
    public long unsequenceChunkGroupNum = 0L;
    public long minStartTime = Long.MAX_VALUE;
    public long maxEndTime = Long.MIN_VALUE;
    private Map<IDeviceID, Map<String, ITimeRange>> chunkStatisticMap = new HashMap<IDeviceID, Map<String, ITimeRange>>();
    private Map<IDeviceID, ITimeRange> chunkGroupStatisticMap = new HashMap<IDeviceID, ITimeRange>();

    public void updateMeasurement(IDeviceID device, String measurementUID, Interval interval) {
        this.chunkStatisticMap.computeIfAbsent(device, key -> new HashMap()).computeIfAbsent(measurementUID, key -> new ListTimeRangeImpl()).addInterval(interval);
    }

    public void updateDevice(IDeviceID device, Interval interval) {
        this.chunkGroupStatisticMap.computeIfAbsent(device, key -> new ListTimeRangeImpl()).addInterval(interval);
    }

    public boolean chunkHasOverlap(IDeviceID device, String measurementUID, Interval interval) {
        if (!this.chunkStatisticMap.containsKey(device)) {
            return false;
        }
        if (!this.chunkStatisticMap.get(device).containsKey(measurementUID)) {
            return false;
        }
        return this.chunkStatisticMap.get(device).get(measurementUID).isOverlapped(interval);
    }

    public boolean chunkGroupHasOverlap(IDeviceID device, Interval interval) {
        if (!this.chunkGroupStatisticMap.containsKey(device)) {
            return false;
        }
        return this.chunkGroupStatisticMap.get(device).isOverlapped(interval);
    }

    public Map<IDeviceID, Map<String, ITimeRange>> getChunkStatisticMap() {
        return this.chunkStatisticMap;
    }

    public Map<IDeviceID, ITimeRange> getChunkGroupStatisticMap() {
        return this.chunkGroupStatisticMap;
    }

    public void setMaxEndTime(long maxEndTime) {
        this.maxEndTime = Math.max(this.maxEndTime, maxEndTime);
    }

    public void setMinStartTime(long minStartTime) {
        this.minStartTime = Math.min(this.minStartTime, minStartTime);
    }
}

