/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.utils.fileTimeIndexCache;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTimeIndexCacheReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTimeIndexCacheReader.class);
    private final File logFile;
    private final long fileLength;
    private final int dataRegionId;

    public FileTimeIndexCacheReader(File logFile, String dataRegionId) {
        this.logFile = logFile;
        this.fileLength = logFile.length();
        this.dataRegionId = Integer.parseInt(dataRegionId);
    }

    public void read(Map<TsFileID, FileTimeIndex> fileTimeIndexMap) throws IOException {
        long readLength;
        try (DataInputStream logStream2 = new DataInputStream(new BufferedInputStream(Files.newInputStream(this.logFile.toPath(), new OpenOption[0])));){
            for (readLength = 0L; readLength < this.fileLength; readLength += (long)TsFileResource.getFileTimeIndexSerializedSize()) {
                long partitionId = logStream2.readLong();
                long timestamp = logStream2.readLong();
                long fileVersion = logStream2.readLong();
                long compactionVersion = logStream2.readLong();
                long minStartTime = logStream2.readLong();
                long maxEndTime = logStream2.readLong();
                TsFileID tsFileID = new TsFileID(this.dataRegionId, partitionId, timestamp, fileVersion, compactionVersion);
                FileTimeIndex fileTimeIndex = new FileTimeIndex(minStartTime, maxEndTime);
                fileTimeIndexMap.put(tsFileID, fileTimeIndex);
            }
        }
        catch (IOException logStream2) {
            // empty catch block
        }
        if (readLength != this.fileLength) {
            try (FileChannel channel = FileChannel.open(this.logFile.toPath(), StandardOpenOption.WRITE);){
                channel.truncate(readLength);
            }
        }
    }
}

