/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl.values;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.tsfile.common.regexp.LikePattern;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LikeFilter
extends SchemaFilter {
    private final LikePattern pattern;

    public LikeFilter(String regex, Optional<Character> escape) {
        this.pattern = LikePattern.compile((String)regex, escape);
    }

    public LikeFilter(ByteBuffer byteBuffer) {
        this.pattern = LikePattern.compile((String)ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer) ? Optional.of(Character.valueOf(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer).charAt(0))) : Optional.empty());
    }

    public LikePattern getPattern() {
        return this.pattern;
    }

    @Override
    public <C> Boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitLikeFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.LIKE;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.pattern.getPattern(), (ByteBuffer)byteBuffer);
        if (this.pattern.getEscape().isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((String)((Character)this.pattern.getEscape().get()).toString(), (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.pattern.getPattern(), (OutputStream)stream);
        if (this.pattern.getEscape().isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((String)((Character)this.pattern.getEscape().get()).toString(), (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikeFilter that = (LikeFilter)o;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }
}

